/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SetObjectUnsupportedTest
extends BaseJDBCTestCase {
    private final TypeInfo typeInfo;
    private final boolean callable;
    private static final TypeInfo[] TYPES = new TypeInfo[]{new TypeInfo("ARRAY", 2003), new TypeInfo("DATALINK", 70), new TypeInfo("NCHAR", -15), new TypeInfo("NCLOB", 2011), new TypeInfo("NVARCHAR", -9), new TypeInfo("LONGNVARCHAR", -16), new TypeInfo("REF", 2006), new TypeInfo("ROWID", -8), new TypeInfo("SQLXML", 2009), new TypeInfo("STRUCT", 2002)};

    private SetObjectUnsupportedTest(String string, TypeInfo typeInfo, boolean bl) {
        super(string);
        this.typeInfo = typeInfo;
        this.callable = bl;
    }

    public String getName() {
        return super.getName() + "_" + this.typeInfo.name;
    }

    private PreparedStatement prepare() throws SQLException {
        String string = "values (CAST (? AS VARCHAR(128)))";
        return this.callable ? this.prepareCall(string) : this.prepareStatement(string);
    }

    public void testUnsupportedSetObject() throws SQLException {
        PreparedStatement preparedStatement = this.prepare();
        try {
            preparedStatement.setObject(1, null, this.typeInfo.type);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        preparedStatement.close();
    }

    public void testUnsupportedSetObjectWithScale() throws SQLException {
        PreparedStatement preparedStatement = this.prepare();
        try {
            preparedStatement.setObject(1, null, this.typeInfo.type, 0);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        preparedStatement.close();
    }

    public void testUnsupportedSetNull() throws SQLException {
        PreparedStatement preparedStatement = this.prepare();
        try {
            preparedStatement.setNull(1, this.typeInfo.type);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        preparedStatement.close();
    }

    public void testUnsupportedSetNullWithTypeName() throws SQLException {
        PreparedStatement preparedStatement = this.prepare();
        try {
            preparedStatement.setNull(1, this.typeInfo.type, this.typeInfo.name);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        preparedStatement.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SetObjectUnsupportedTest suite");
        baseTestSuite.addTest(SetObjectUnsupportedTest.baseSuite(false, "SetObjectUnsupportedTest:prepared"));
        baseTestSuite.addTest(SetObjectUnsupportedTest.baseSuite(true, "SetObjectUnsupportedTest:callable"));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("SetObjectUnsupportedTest:client");
        baseTestSuite2.addTest(SetObjectUnsupportedTest.baseSuite(false, "SetObjectUnsupportedTest:prepared"));
        baseTestSuite2.addTest(SetObjectUnsupportedTest.baseSuite(true, "SetObjectUnsupportedTest:callable"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite2));
        return baseTestSuite;
    }

    static Test baseSuite(boolean bl, String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        for (TypeInfo typeInfo : TYPES) {
            baseTestSuite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetObject", typeInfo, bl));
            baseTestSuite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetObjectWithScale", typeInfo, bl));
            baseTestSuite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetNull", typeInfo, bl));
            baseTestSuite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetNullWithTypeName", typeInfo, bl));
        }
        return baseTestSuite;
    }

    private static class TypeInfo {
        final String name;
        final int type;

        TypeInfo(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }
}

