/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.DBOperations;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UniqueConstraintMultiThreadedTest
extends BaseJDBCTestCase {
    public UniqueConstraintMultiThreadedTest() {
        super("Multi Threaded Unique Constraint Test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeThreads(int n, int n2, boolean bl) throws Exception {
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(n);
        Connection connection2 = this.openDefaultConnection();
        try {
            connection2.setTransactionIsolation(n2);
            DBOperations dBOperations = new DBOperations(connection, 5);
            DBOperations dBOperations2 = new DBOperations(connection2, 5);
            dBOperations.delete();
            Thread thread = new Thread(dBOperations2);
            thread.start();
            Thread.sleep(2000L);
            if (bl) {
                dBOperations.rollback();
                thread.join();
                UniqueConstraintMultiThreadedTest.assertSQLState("isolation levels: " + n + " " + n2, "23505", dBOperations2.getException());
            } else {
                dBOperations.commit();
                thread.join();
                UniqueConstraintMultiThreadedTest.assertNull((String)("isolation levels: " + n + " " + n2), (Object)dBOperations2.getException());
            }
            UniqueConstraintMultiThreadedTest.assertNull((String)("unexpected failure: " + n + " " + n2), (Object)dBOperations2.getUnexpectedException());
        }
        finally {
            connection.commit();
            connection2.commit();
            connection.close();
            connection2.close();
        }
    }

    public void testLockingWithcommit() throws Exception {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.executeThreads((int)Math.pow(2.0, i), (int)Math.pow(2.0, j), true);
            }
        }
    }

    public void testLockingWithRollback() throws Exception {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.executeThreads((int)Math.pow(2.0, i), (int)Math.pow(2.0, j), false);
            }
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UniqueConstraintTest");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(UniqueConstraintMultiThreadedTest.class));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table tab1 (i integer)");
        statement.executeUpdate("alter table tab1 add constraint con1 unique (i)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into tab1 values (?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        this.dropTable("tab1");
        super.tearDown();
    }
}

