/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.File;
import java.net.URI;
import org.apache.daffodil.lib.iapi.TDMLImplementation;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.tdml.DFDLTestSuite;
import org.apache.daffodil.tdml.RoundTrip;
import org.apache.daffodil.tdml.Runner$;
import org.apache.daffodil.tdml.TestCase;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.xml.Elem;

public final class Runner {
    private final Either<Elem, String> source;
    private final Option<TDMLImplementation> optTDMLImplementation;
    private final boolean validateTDMLFile;
    private final boolean validateDFDLSchemas;
    private final boolean compileAllTopLevel;
    private final RoundTrip defaultRoundTripDefault;
    private final String defaultValidationDefault;
    private final Seq<String> defaultImplementationsDefault;
    private final boolean defaultIgnoreUnexpectedWarningsDefault;
    private final boolean defaultIgnoreUnexpectedValidationErrorsDefault;
    private DFDLTestSuite ts;

    public static Runner apply(Elem elem) {
        return Runner$.MODULE$.apply(elem);
    }

    public static Runner apply(Elem elem, boolean bl) {
        return Runner$.MODULE$.apply(elem, bl);
    }

    public static Runner apply(String string) {
        return Runner$.MODULE$.apply(string);
    }

    public static Runner apply(String string, Option<TDMLImplementation> option) {
        return Runner$.MODULE$.apply(string, option);
    }

    public static Runner apply(String string, String string2, TDMLImplementation tDMLImplementation, boolean bl, boolean bl2, boolean bl3, RoundTrip roundTrip, String string3, Seq<String> seq) {
        return Runner$.MODULE$.apply(string, string2, tDMLImplementation, bl, bl2, bl3, roundTrip, string3, seq);
    }

    public static Seq<String> defaultImplementationsDefaultDefault() {
        return Runner$.MODULE$.defaultImplementationsDefaultDefault();
    }

    public static RoundTrip defaultRoundTripDefaultDefault() {
        return Runner$.MODULE$.defaultRoundTripDefaultDefault();
    }

    public static boolean defaultShouldDoErrorComparisonOnCrossTests() {
        return Runner$.MODULE$.defaultShouldDoErrorComparisonOnCrossTests();
    }

    public static boolean defaultShouldDoWarningComparisonOnCrossTests() {
        return Runner$.MODULE$.defaultShouldDoWarningComparisonOnCrossTests();
    }

    public static String defaultValidationDefaultDefault() {
        return Runner$.MODULE$.defaultValidationDefaultDefault();
    }

    public static Option<TDMLImplementation> $lessinit$greater$default$2() {
        return Runner$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return Runner$.MODULE$.$lessinit$greater$default$3();
    }

    public static TDMLImplementation apply$default$3() {
        return Runner$.MODULE$.apply$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return Runner$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean apply$default$4() {
        return Runner$.MODULE$.apply$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return Runner$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean apply$default$5() {
        return Runner$.MODULE$.apply$default$5();
    }

    public static RoundTrip $lessinit$greater$default$6() {
        return Runner$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean apply$default$6() {
        return Runner$.MODULE$.apply$default$6();
    }

    public static String $lessinit$greater$default$7() {
        return Runner$.MODULE$.$lessinit$greater$default$7();
    }

    public static RoundTrip apply$default$7() {
        return Runner$.MODULE$.apply$default$7();
    }

    public static Seq<String> $lessinit$greater$default$8() {
        return Runner$.MODULE$.$lessinit$greater$default$8();
    }

    public static String apply$default$8() {
        return Runner$.MODULE$.apply$default$8();
    }

    public static boolean $lessinit$greater$default$9() {
        return Runner$.MODULE$.$lessinit$greater$default$9();
    }

    public static Seq<String> apply$default$9() {
        return Runner$.MODULE$.apply$default$9();
    }

    public static boolean $lessinit$greater$default$10() {
        return Runner$.MODULE$.$lessinit$greater$default$10();
    }

    public Runner(Either<Elem, String> source, Option<TDMLImplementation> optTDMLImplementation, boolean validateTDMLFile, boolean validateDFDLSchemas, boolean compileAllTopLevel, RoundTrip defaultRoundTripDefault, String defaultValidationDefault, Seq<String> defaultImplementationsDefault, boolean defaultIgnoreUnexpectedWarningsDefault, boolean defaultIgnoreUnexpectedValidationErrorsDefault) {
        this.source = source;
        this.optTDMLImplementation = optTDMLImplementation;
        this.validateTDMLFile = validateTDMLFile;
        this.validateDFDLSchemas = validateDFDLSchemas;
        this.compileAllTopLevel = compileAllTopLevel;
        this.defaultRoundTripDefault = defaultRoundTripDefault;
        this.defaultValidationDefault = defaultValidationDefault;
        this.defaultImplementationsDefault = defaultImplementationsDefault;
        this.defaultIgnoreUnexpectedWarningsDefault = defaultIgnoreUnexpectedWarningsDefault;
        this.defaultIgnoreUnexpectedValidationErrorsDefault = defaultIgnoreUnexpectedValidationErrorsDefault;
        this.ts = null;
    }

    public Runner(String path) {
        this((Either<Elem, String>)(path.startsWith("/") ? package$.MODULE$.Right().apply((Object)path) : package$.MODULE$.Right().apply((Object)("/" + path))), Runner$.MODULE$.$lessinit$greater$default$2(), Runner$.MODULE$.$lessinit$greater$default$3(), Runner$.MODULE$.$lessinit$greater$default$4(), Runner$.MODULE$.$lessinit$greater$default$5(), Runner$.MODULE$.$lessinit$greater$default$6(), Runner$.MODULE$.$lessinit$greater$default$7(), Runner$.MODULE$.$lessinit$greater$default$8(), Runner$.MODULE$.$lessinit$greater$default$9(), Runner$.MODULE$.$lessinit$greater$default$10());
    }

    public Runner(String dir, String file) {
        this(dir.endsWith("/") ? dir + file : dir + "/" + file);
    }

    public Runner(URI uri) {
        this((Either<Elem, String>)package$.MODULE$.Right().apply((Object)uri.toString()), Runner$.MODULE$.$lessinit$greater$default$2(), Runner$.MODULE$.$lessinit$greater$default$3(), Runner$.MODULE$.$lessinit$greater$default$4(), Runner$.MODULE$.$lessinit$greater$default$5(), Runner$.MODULE$.$lessinit$greater$default$6(), Runner$.MODULE$.$lessinit$greater$default$7(), Runner$.MODULE$.$lessinit$greater$default$8(), Runner$.MODULE$.$lessinit$greater$default$9(), Runner$.MODULE$.$lessinit$greater$default$10());
    }

    public Runner(File file) {
        this(file.toURI());
    }

    public Runner(Elem elem) {
        this((Either<Elem, String>)package$.MODULE$.Left().apply((Object)elem), Runner$.MODULE$.$lessinit$greater$default$2(), Runner$.MODULE$.$lessinit$greater$default$3(), Runner$.MODULE$.$lessinit$greater$default$4(), Runner$.MODULE$.$lessinit$greater$default$5(), Runner$.MODULE$.$lessinit$greater$default$6(), Runner$.MODULE$.$lessinit$greater$default$7(), Runner$.MODULE$.$lessinit$greater$default$8(), Runner$.MODULE$.$lessinit$greater$default$9(), Runner$.MODULE$.$lessinit$greater$default$10());
    }

    public DFDLTestSuite getTS() {
        DFDLTestSuite dFDLTestSuite;
        Runner runner = this;
        synchronized (runner) {
            if (this.ts == null) {
                Elem elem;
                Either<Elem, String> either = this.source;
                if (either instanceof Left) {
                    Elem l;
                    elem = l = (Elem)((Left)either).value();
                } else if (either instanceof Right) {
                    String r = (String)((Right)either).value();
                    URI uri = r.startsWith("/") ? Misc$.MODULE$.getRequiredResource(r) : new URI(r);
                    elem = URISchemaSource$.MODULE$.apply(new File(r), uri);
                } else {
                    throw new MatchError(either);
                }
                Elem elemOrURISchemaSource = elem;
                this.ts = new DFDLTestSuite(elemOrURISchemaSource, this.optTDMLImplementation, this.validateTDMLFile, this.validateDFDLSchemas, this.compileAllTopLevel, this.defaultRoundTripDefault, this.defaultValidationDefault, this.defaultImplementationsDefault, Runner$.MODULE$.defaultShouldDoErrorComparisonOnCrossTests(), Runner$.MODULE$.defaultShouldDoWarningComparisonOnCrossTests(), this.defaultIgnoreUnexpectedWarningsDefault, this.defaultIgnoreUnexpectedValidationErrorsDefault);
            }
            dFDLTestSuite = this.ts;
        }
        return dFDLTestSuite;
    }

    public void runOneTest(String testName, boolean leakCheck) {
        try {
            this.getTS().runOneTest(testName, leakCheck);
        }
        finally {
            this.getTS().setDebugging(false);
        }
    }

    public boolean runOneTest$default$2() {
        return false;
    }

    public void runOneTest(String testName) {
        this.runOneTest(testName, false);
    }

    public void runAllTests() {
        this.getTS().runAllTests();
    }

    public Seq<TestCase> testCases() {
        return this.getTS().testCases();
    }

    public void reset() {
        if (this.ts != null) {
            this.ts.cleanUp();
        }
        this.ts = null;
    }

    public Runner trace() {
        this.getTS().trace();
        return this;
    }

    public void setDebugger(Object db) {
        this.getTS().setDebugger(db);
        this.debug();
    }

    public void debug() {
        this.getTS().setDebugging(true);
    }
}

