/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.tools.rngdatatype.ValidationContext;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.impl.ForeignAttributesImpl;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.UName;
import com.sun.xml.xsom.impl.parser.DefaultAnnotationParser;
import com.sun.xml.xsom.impl.parser.Messages;
import com.sun.xml.xsom.impl.parser.ParserContext;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import com.sun.xml.xsom.impl.parser.SchemaDocumentImpl;
import com.sun.xml.xsom.impl.parser.state.NGCCRuntime;
import com.sun.xml.xsom.impl.parser.state.Schema;
import com.sun.xml.xsom.parser.AnnotationParser;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Stack;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class NGCCRuntimeEx
extends NGCCRuntime
implements PatcherManager {
    public final ParserContext parser;
    public SchemaImpl currentSchema;
    public int finalDefault = 0;
    public int blockDefault = 0;
    public boolean elementFormDefault = false;
    public boolean attributeFormDefault = false;
    public boolean chameleonMode = false;
    private String documentSystemId;
    private final Stack<String> elementNames = new Stack();
    private final NGCCRuntimeEx referer;
    public SchemaDocumentImpl document;
    private static final Pattern P = Pattern.compile(".*[/#?].*");
    private Context currentContext = null;

    NGCCRuntimeEx(ParserContext _parser) {
        this(_parser, false, null);
    }

    private NGCCRuntimeEx(ParserContext _parser, boolean chameleonMode, NGCCRuntimeEx referer) {
        this.parser = _parser;
        this.chameleonMode = chameleonMode;
        this.referer = referer;
        this.currentContext = new Context("", "", null);
        this.currentContext = new Context("xml", "http://www.w3.org/XML/1998/namespace", this.currentContext);
    }

    public void checkDoubleDefError(XSDeclaration c) throws SAXException {
        if (c == null || NGCCRuntimeEx.ignorableDuplicateComponent(c)) {
            return;
        }
        this.reportError(Messages.format("DoubleDefinition", c.getName()));
        this.reportError(Messages.format("DoubleDefinition.Original", new Object[0]), c.getLocator());
    }

    public static boolean ignorableDuplicateComponent(XSDeclaration c) {
        if ("http://www.w3.org/2001/XMLSchema".equals(c.getTargetNamespace())) {
            if (c instanceof XSSimpleType) {
                return true;
            }
            return c.isGlobal() && "anyType".equals(c.getName());
        }
        return false;
    }

    @Override
    public void addPatcher(Patch patcher) {
        this.parser.patcherManager.addPatcher(patcher);
    }

    @Override
    public void addErrorChecker(Patch patcher) {
        this.parser.patcherManager.addErrorChecker(patcher);
    }

    @Override
    public void reportError(String msg, Locator loc) throws SAXException {
        this.parser.patcherManager.reportError(msg, loc);
    }

    public void reportError(String msg) throws SAXException {
        this.reportError(msg, this.getLocator());
    }

    private InputSource resolveRelativeURL(String namespaceURI, String relativeUri) throws SAXException {
        try {
            String baseUri = this.getLocator().getSystemId();
            if (baseUri == null) {
                baseUri = this.documentSystemId;
            }
            EntityResolver er = this.parser.getEntityResolver();
            String systemId = null;
            if (relativeUri != null) {
                if (NGCCRuntimeEx.isAbsolute(relativeUri)) {
                    systemId = relativeUri;
                } else {
                    if (baseUri == null || !NGCCRuntimeEx.isAbsolute(baseUri)) {
                        throw new IOException("Unable to resolve relative URI " + relativeUri + " because base URI is not absolute: " + baseUri);
                    }
                    systemId = new URL(new URL(baseUri), relativeUri).toString();
                }
            }
            if (er != null) {
                InputSource is = er.resolveEntity(namespaceURI, systemId == null ? "" : systemId);
                if (is == null) {
                    try {
                        String normalizedSystemId = URI.create(systemId).normalize().toASCIIString();
                        is = er.resolveEntity(namespaceURI, normalizedSystemId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    return is;
                }
            }
            if (systemId != null) {
                return new InputSource(systemId);
            }
            return null;
        }
        catch (IOException e) {
            SAXParseException se = new SAXParseException(e.getMessage(), this.getLocator(), e);
            this.parser.errorHandler.error(se);
            return null;
        }
    }

    private static boolean isAbsolute(String uri) {
        int i = uri.indexOf(58);
        if (i < 0) {
            return false;
        }
        return !P.matcher(uri.substring(0, i)).matches();
    }

    public void includeSchema(String schemaLocation) throws SAXException {
        NGCCRuntimeEx runtime = new NGCCRuntimeEx(this.parser, this.chameleonMode, this);
        runtime.currentSchema = this.currentSchema;
        runtime.blockDefault = this.blockDefault;
        runtime.finalDefault = this.finalDefault;
        if (schemaLocation == null) {
            SAXParseException e = new SAXParseException(Messages.format("MissingSchemaLocation", new Object[0]), this.getLocator());
            this.parser.errorHandler.fatalError(e);
            throw e;
        }
        runtime.parseEntity(this.resolveRelativeURL(null, schemaLocation), true, this.currentSchema.getTargetNamespace(), this.getLocator());
    }

    public void importSchema(String ns, String schemaLocation) throws SAXException {
        NGCCRuntimeEx newRuntime = new NGCCRuntimeEx(this.parser, false, this);
        InputSource source = this.resolveRelativeURL(ns, schemaLocation);
        if (source != null) {
            newRuntime.parseEntity(source, false, ns, this.getLocator());
        }
    }

    public boolean hasAlreadyBeenRead() {
        if (this.documentSystemId != null && this.documentSystemId.startsWith("file:///")) {
            this.documentSystemId = "file:/" + this.documentSystemId.substring(8);
        }
        assert (this.document == null);
        this.document = new SchemaDocumentImpl(this.currentSchema, this.documentSystemId);
        SchemaDocumentImpl existing = this.parser.parsedDocuments.get(this.document);
        if (existing == null) {
            this.parser.parsedDocuments.put(this.document, this.document);
        } else {
            this.document = existing;
        }
        assert (this.document != null);
        if (this.referer != null) {
            assert (this.referer.document != null) : "referer " + this.referer.documentSystemId + " has docIdentity==null";
            this.referer.document.references.add(this.document);
            this.document.referers.add(this.referer.document);
        }
        return existing != null;
    }

    public void parseEntity(InputSource source, boolean includeMode, String expectedNamespace, Locator importLocation) throws SAXException {
        this.documentSystemId = source.getSystemId();
        try {
            Schema s = new Schema(this, includeMode, expectedNamespace);
            this.setRootHandler(s);
            try {
                this.parser.parser.parse(source, this, this.getErrorHandler(), this.parser.getEntityResolver());
            }
            catch (IOException fnfe) {
                SAXParseException se = new SAXParseException(fnfe.toString(), importLocation, fnfe);
                this.parser.errorHandler.warning(se);
            }
        }
        catch (SAXException e) {
            this.parser.setErrorFlag();
            throw e;
        }
    }

    public AnnotationParser createAnnotationParser() {
        if (this.parser.getAnnotationParserFactory() == null) {
            return DefaultAnnotationParser.theInstance;
        }
        return this.parser.getAnnotationParserFactory().create();
    }

    public String getAnnotationContextElementName() {
        return (String)this.elementNames.get(this.elementNames.size() - 2);
    }

    public Locator copyLocator() {
        return new LocatorImpl(this.getLocator());
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.errorHandler;
    }

    @Override
    public void onEnterElementConsumed(String uri, String localName, String qname2, Attributes atts) throws SAXException {
        super.onEnterElementConsumed(uri, localName, qname2, atts);
        this.elementNames.push(localName);
    }

    @Override
    public void onLeaveElementConsumed(String uri, String localName, String qname2) throws SAXException {
        super.onLeaveElementConsumed(uri, localName, qname2);
        this.elementNames.pop();
    }

    public ValidationContext createValidationContext() {
        return this.currentContext;
    }

    public XmlString createXmlString(String value) {
        if (value == null) {
            return null;
        }
        return new XmlString(value, this.createValidationContext());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.currentContext = new Context(prefix, uri, this.currentContext);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.currentContext = this.currentContext.previous;
    }

    public UName parseUName(String qname2) throws SAXException {
        int idx = qname2.indexOf(58);
        if (idx < 0) {
            String uri = this.resolveNamespacePrefix("");
            if (uri.equals("") && this.chameleonMode) {
                uri = this.currentSchema.getTargetNamespace();
            }
            return new UName(uri, qname2, qname2);
        }
        String prefix = qname2.substring(0, idx);
        String uri = this.currentContext.resolveNamespacePrefix(prefix);
        if (uri == null) {
            this.reportError(Messages.format("UndefinedPrefix", prefix));
            uri = "undefined";
        }
        return new UName(uri, qname2.substring(idx + 1), qname2);
    }

    public String collapse(String text) {
        return this.collapse((CharSequence)text).toString();
    }

    private boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    private CharSequence collapse(CharSequence text) {
        int s;
        int len = text.length();
        for (s = 0; s < len && !this.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        StringBuilder result = new StringBuilder(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = this.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result;
    }

    public boolean parseBoolean(String v) {
        if (v == null) {
            return false;
        }
        return (v = v.trim()).equals("true") || v.equals("1");
    }

    @Override
    protected void unexpectedX(String token) throws SAXException {
        SAXParseException e = new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", token, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()), this.getLocator());
        this.parser.errorHandler.fatalError(e);
        throw e;
    }

    public ForeignAttributesImpl parseForeignAttributes(ForeignAttributesImpl next) {
        ForeignAttributesImpl impl = new ForeignAttributesImpl(this.createValidationContext(), this.copyLocator(), next);
        Attributes atts = this.getCurrentAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getURI(i).length() <= 0) continue;
            impl.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        return impl;
    }

    private static class Context
    implements ValidationContext {
        private final String prefix;
        private final String uri;
        private final Context previous;

        Context(String _prefix, String _uri, Context _context) {
            this.previous = _context;
            this.prefix = _prefix;
            this.uri = _uri;
        }

        public String resolveNamespacePrefix(String p) {
            if (p.equals(this.prefix)) {
                return this.uri;
            }
            if (this.previous == null) {
                return null;
            }
            return this.previous.resolveNamespacePrefix(p);
        }

        public String getBaseUri() {
            return null;
        }

        public boolean isNotation(String arg0) {
            return false;
        }

        public boolean isUnparsedEntity(String arg0) {
            return false;
        }
    }
}

