/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.chain.commands.AbstractSelectForward;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

public abstract class AbstractValidateActionForm
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(AbstractSelectForward.class);

    private boolean isCancelled(ActionContext actionCtx, ActionConfig actionConfig) throws InvalidCancelException {
        boolean invalidState;
        Boolean cancel = actionCtx.getCancelled();
        boolean cancelled = cancel != null && cancel != false;
        boolean cancellable = actionConfig.getCancellable();
        boolean bl = invalidState = cancelled && !cancellable;
        if (invalidState) {
            actionCtx.setCancelled(Boolean.FALSE);
            actionCtx.setFormValid(Boolean.FALSE);
            throw new InvalidCancelException();
        }
        return cancelled;
    }

    public boolean execute(ActionContext actionCtx) throws Exception {
        actionCtx.setFormValid(Boolean.TRUE);
        ActionForm actionForm = actionCtx.getActionForm();
        if (actionForm == null) {
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        if (!actionConfig.getValidate()) {
            return false;
        }
        if (this.isCancelled(actionCtx, actionConfig)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Cancelled transaction, skipping validation");
            }
            return false;
        }
        ActionErrors errors = this.validate(actionCtx, actionConfig, actionForm);
        if (errors == null || errors.isEmpty()) {
            return false;
        }
        actionCtx.saveErrors(errors);
        actionCtx.setFormValid(Boolean.FALSE);
        return false;
    }

    protected abstract ActionErrors validate(ActionContext var1, ActionConfig var2, ActionForm var3);
}

