/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class LogOutputStream
extends OutputStream {
    private static final int INITIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStreamX buffer = new ByteArrayOutputStreamX(132);
    private boolean skip;
    private final int level;
    private final Charset charset;

    public LogOutputStream() {
        this(999);
    }

    public LogOutputStream(int level) {
        this(level, null);
    }

    public LogOutputStream(int level, Charset charset) {
        this.level = level;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    public int getMessageLevel() {
        return this.level;
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString(this.charset));
        this.buffer.reset();
    }

    protected void processLine(String line) {
        this.processLine(line, this.level);
    }

    protected abstract void processLine(String var1, int var2);

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int offset;
        int blockStartOffset = offset = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b[offset] != 10 && b[offset] != 13) {
                ++offset;
                --remaining;
            }
            int blockLength = offset - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b[offset] == 10 || b[offset] == 13)) {
                this.write(b[offset]);
                ++offset;
                --remaining;
            }
            blockStartOffset = offset;
        }
    }

    @Override
    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    private static final class ByteArrayOutputStreamX
    extends ByteArrayOutputStream {
        private ByteArrayOutputStreamX(int size) {
            super(size);
        }

        @Override
        public synchronized String toString(Charset charset) {
            return new String(this.buf, 0, this.count, charset);
        }
    }
}

