/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.function.Supplier;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.concurrent.Accumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseResolver<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>> {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseResolver.class);
    protected final ReadCommand command;
    protected final Supplier<? extends P> replicaPlan;
    protected final Accumulator<Message<ReadResponse>> responses;
    protected final Dispatcher.RequestTime requestTime;

    public ResponseResolver(ReadCommand command, Supplier<? extends P> replicaPlan, Dispatcher.RequestTime requestTime) {
        this.command = command;
        this.replicaPlan = replicaPlan;
        this.responses = new Accumulator(((AbstractReplicaCollection)((ReplicaPlan.ForRead)replicaPlan.get()).readCandidates()).size());
        this.requestTime = requestTime;
    }

    protected P replicaPlan() {
        return (P)((ReplicaPlan.ForRead)this.replicaPlan.get());
    }

    public abstract boolean isDataPresent();

    public void preprocess(Message<ReadResponse> message) {
        if (this.replicaPlan().lookup(message.from()).isTransient() && ((ReadResponse)message.payload).isDigestResponse()) {
            throw new IllegalArgumentException("Digest response received from transient replica");
        }
        try {
            this.responses.add(message);
        }
        catch (IllegalStateException e) {
            logger.error("Encountered error while trying to preprocess the message {}, in command {}, replica plan: {}", new Object[]{message, this.command, this.replicaPlan});
            throw e;
        }
    }

    public Accumulator<Message<ReadResponse>> getMessages() {
        return this.responses;
    }
}

