/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicCompositeType
extends AbstractCompositeType {
    private static final Logger logger = LoggerFactory.getLogger(DynamicCompositeType.class);
    private static final ByteSource[] EMPTY_BYTE_SOURCE_ARRAY = new ByteSource[0];
    private static final String REVERSED_TYPE = ReversedType.class.getSimpleName();
    @VisibleForTesting
    public final Map<Byte, AbstractType<?>> aliases;
    private final Map<AbstractType<?>, Byte> inverseMapping;
    private final Serializer serializer;
    private static final ConcurrentHashMap<Map<Byte, AbstractType<?>>, DynamicCompositeType> instances = new ConcurrentHashMap();

    public static DynamicCompositeType getInstance(TypeParser parser) {
        return DynamicCompositeType.getInstance(parser.getAliasParameters());
    }

    public static DynamicCompositeType getInstance(Map<Byte, AbstractType<?>> aliases) {
        DynamicCompositeType dct = instances.get(aliases);
        return null == dct ? instances.computeIfAbsent(aliases, DynamicCompositeType::new) : dct;
    }

    private DynamicCompositeType(Map<Byte, AbstractType<?>> aliases) {
        this.aliases = ImmutableMap.copyOf(aliases);
        this.serializer = new Serializer(this.aliases);
        this.inverseMapping = new HashMap();
        for (Map.Entry<Byte, AbstractType<?>> en : aliases.entrySet()) {
            this.inverseMapping.put(en.getValue(), en.getKey());
        }
    }

    public int size() {
        return this.aliases.size();
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return new ArrayList(this.aliases.values());
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }

    @Override
    protected <V> boolean readIsStatic(V value, ValueAccessor<V> accessor) {
        return false;
    }

    @Override
    protected int startingOffset(boolean isStatic) {
        return 0;
    }

    @Override
    protected <V> int getComparatorSize(int i, V value, ValueAccessor<V> accessor, int offset) {
        short header = accessor.getShort(value, offset);
        if ((header & 0x8000) == 0) {
            return 2 + header;
        }
        return 2;
    }

    private <V> AbstractType<?> getComparator(V value, ValueAccessor<V> accessor, int offset) {
        try {
            short header = accessor.getShort(value, offset);
            if ((header & 0x8000) == 0) {
                String name = accessor.toString(accessor.slice(value, offset + 2, header));
                return TypeParser.parse(name);
            }
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <V> AbstractType<?> getComparator(int i, V value, ValueAccessor<V> accessor, int offset) {
        return this.getComparator(value, accessor, offset);
    }

    @Override
    protected <VL, VR> AbstractType<?> getComparator(int i, VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR, int offsetL, int offsetR) {
        AbstractType<Object> comp1 = this.getComparator(left, accessorL, offsetL);
        AbstractType<Object> comp2 = this.getComparator(right, accessorR, offsetR);
        AbstractType<?> rawComp = comp1;
        if (comp1 instanceof ReversedType && comp2 instanceof ReversedType) {
            comp1 = ((ReversedType)comp1).baseType;
            comp2 = ((ReversedType)comp2).baseType;
        }
        if (comp1 != comp2) {
            int cmp = comp1.getClass().getSimpleName().compareTo(comp2.getClass().getSimpleName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
            cmp = comp1.getClass().getName().compareTo(comp2.getClass().getName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
        }
        return rawComp;
    }

    @Override
    protected <V> AbstractType<?> getAndAppendComparator(int i, V value, ValueAccessor<V> accessor, StringBuilder sb, int offset) {
        try {
            short header = accessor.getShort(value, offset);
            if ((header & 0x8000) == 0) {
                String name = accessor.toString(accessor.slice(value, offset + 2, header));
                sb.append(name).append("@");
                return TypeParser.parse(name);
            }
            sb.append((char)(header & 0xFF)).append("@");
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        ArrayList<ByteSource> srcs = new ArrayList<ByteSource>();
        int length = accessor.size(data);
        boolean isStatic = this.readIsStatic(data, accessor);
        int offset = this.startingOffset(isStatic);
        srcs.add(isStatic ? null : ByteSource.EMPTY);
        int lastEoc = 0;
        int i = 0;
        while (offset < length) {
            assert (lastEoc == 0) : lastEoc;
            AbstractType<?> comp = this.getComparator(data, accessor, offset);
            offset += this.getComparatorSize(i, data, accessor, offset);
            if (version == ByteComparable.Version.LEGACY || !(comp instanceof ReversedType)) {
                srcs.add(ByteSource.of(comp.getClass().getSimpleName(), version));
                srcs.add(ByteSource.of(comp.getClass().getName(), version));
            } else {
                ReversedType reversedComp = (ReversedType)comp;
                srcs.add(ByteSource.of(REVERSED_TYPE, version));
                srcs.add(ByteSource.of(reversedComp.baseType.getClass().getSimpleName(), version));
                srcs.add(ByteSource.of(reversedComp.baseType.getClass().getName(), version));
            }
            int componentLength = accessor.getUnsignedShort(data, offset);
            srcs.add(comp.asComparableBytes(accessor, accessor.slice(data, offset += 2, componentLength), version));
            lastEoc = accessor.getByte(data, offset += componentLength);
            ++offset;
            srcs.add(ByteSource.oneByte(version == ByteComparable.Version.LEGACY ? lastEoc : lastEoc & 0xFF ^ 0x80));
            ++i;
        }
        return ByteSource.withTerminatorMaybeLegacy(version, -1, srcs.toArray(EMPTY_BYTE_SOURCE_ARRAY));
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        assert (version != ByteComparable.Version.LEGACY);
        if (comparableBytes == null) {
            return accessor.empty();
        }
        comparableBytes.next();
        ArrayList types = new ArrayList();
        ArrayList<V> values = new ArrayList<V>();
        byte lastEoc = 0;
        int separator = comparableBytes.next();
        while (separator != 56) {
            assert (lastEoc == 0) : lastEoc;
            boolean isReversed = false;
            String simpleClassName = ByteSourceInverse.getString(ByteSourceInverse.nextComponentSource(comparableBytes, separator));
            if (REVERSED_TYPE.equals(simpleClassName)) {
                isReversed = true;
                simpleClassName = ByteSourceInverse.getString(ByteSourceInverse.nextComponentSource(comparableBytes));
            }
            Object fullClassName = ByteSourceInverse.getString(ByteSourceInverse.nextComponentSource(comparableBytes));
            assert (((String)fullClassName).endsWith(simpleClassName));
            if (isReversed) {
                fullClassName = REVERSED_TYPE + "(" + (String)fullClassName + ")";
            }
            AbstractType<?> type = TypeParser.parse((String)fullClassName);
            assert (type != null);
            types.add(type);
            V value = type.fromComparableBytes(accessor, ByteSourceInverse.nextComponentSource(comparableBytes), version);
            values.add(value);
            lastEoc = ByteSourceInverse.getSignedByte(ByteSourceInverse.nextComponentSource(comparableBytes));
            separator = comparableBytes.next();
        }
        return DynamicCompositeType.build(accessor, types, this.inverseMapping, values, lastEoc);
    }

    public ByteBuffer build(Map<Byte, Object> valuesMap) {
        Sets.SetView unknownAliases = Sets.difference(valuesMap.keySet(), this.aliases.keySet());
        if (!unknownAliases.isEmpty()) {
            throw new IllegalArgumentException(String.format("Aliases %s used; only valid values are %s", unknownAliases, this.aliases.keySet()));
        }
        ArrayList types = new ArrayList(valuesMap.size());
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(valuesMap.size());
        for (Map.Entry<Byte, Object> e : valuesMap.entrySet()) {
            AbstractType<?> type = this.aliases.get(e.getKey());
            types.add(type);
            values.add(type.decompose(e.getValue()));
        }
        return DynamicCompositeType.build(ByteBufferAccessor.instance, types, this.inverseMapping, values, (byte)0);
    }

    public static ByteBuffer build(List<String> types, List<ByteBuffer> values) {
        return DynamicCompositeType.build(ByteBufferAccessor.instance, Lists.transform(types, TypeParser::parse), Collections.emptyMap(), values, (byte)0);
    }

    @VisibleForTesting
    public static <V> V build(ValueAccessor<V> accessor, List<AbstractType<?>> types, Map<AbstractType<?>, Byte> inverseMapping, List<V> values, byte lastEoc) {
        assert (types.size() == values.size());
        int numComponents = types.size();
        int totalLength = 0;
        for (int i = 0; i < numComponents; ++i) {
            int typeNameLength;
            AbstractType<?> type = types.get(i);
            Byte alias = inverseMapping.get(type);
            int n = typeNameLength = alias == null ? type.toString().getBytes(StandardCharsets.UTF_8).length : 0;
            assert (typeNameLength <= Short.MAX_VALUE);
            int valueLength = accessor.size(values.get(i));
            assert (valueLength <= Short.MAX_VALUE);
            totalLength += 2 + typeNameLength + 2 + valueLength + 1;
        }
        V result = accessor.allocate(totalLength);
        int offset = 0;
        for (int i = 0; i < numComponents; ++i) {
            AbstractType<?> type = types.get(i);
            Byte alias = inverseMapping.get(type);
            if (alias == null) {
                byte[] typeNameBytes = type.toString().getBytes(StandardCharsets.UTF_8);
                accessor.putShort(result, offset, (short)typeNameBytes.length);
                accessor.copyByteArrayTo(typeNameBytes, 0, result, offset += 2, typeNameBytes.length);
                offset += typeNameBytes.length;
            } else {
                accessor.putShort(result, offset, (short)(alias | 0x8000));
                offset += 2;
            }
            V value = values.get(i);
            int bytesToCopy = accessor.size(value);
            if ((short)bytesToCopy != bytesToCopy) {
                throw new IllegalArgumentException(String.format("Value of type %s is of length %d; does not fit in a short", type.asCQL3Type(), bytesToCopy));
            }
            accessor.putShort(result, offset, (short)bytesToCopy);
            accessor.copyTo(value, 0, result, accessor, offset += 2, bytesToCopy);
            accessor.putByte(result, offset += bytesToCopy, i != numComponents - 1 ? (byte)0 : lastEoc);
            ++offset;
        }
        return result;
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new DynamicParsedComparator(part);
    }

    @Override
    protected <V> AbstractType<?> validateComparator(int i, V input, ValueAccessor<V> accessor, int offset) throws MarshalException {
        AbstractType<?> comparator = null;
        if (accessor.sizeFromOffset(input, offset) < 2) {
            throw new MarshalException("Not enough bytes to header of the comparator part of component " + i);
        }
        short header = accessor.getShort(input, offset);
        offset += 2;
        if ((header & 0x8000) == 0) {
            if (accessor.sizeFromOffset(input, offset) < header) {
                throw new MarshalException("Not enough bytes to read comparator name of component " + i);
            }
            V value = accessor.slice(input, offset, header);
            String valueStr = null;
            try {
                valueStr = accessor.toString(value);
                comparator = TypeParser.parse(valueStr);
            }
            catch (CharacterCodingException ce) {
                logger.error("Failed when decoding the byte buffer in ByteBufferUtil.string()", (Throwable)ce);
            }
            catch (Exception e) {
                logger.error("Failed to parse value string \"{}\" with exception:", (Object)valueStr, (Object)e);
            }
        } else {
            comparator = this.aliases.get((byte)(header & 0xFF));
        }
        if (comparator == null) {
            throw new MarshalException("Cannot find comparator for component " + i);
        }
        return comparator;
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof DynamicCompositeType)) {
            return false;
        }
        DynamicCompositeType cp = (DynamicCompositeType)previous;
        if (this.aliases.size() < cp.aliases.size()) {
            return false;
        }
        for (Map.Entry<Byte, AbstractType<?>> entry : cp.aliases.entrySet()) {
            AbstractType<?> tprev = entry.getValue();
            AbstractType<?> tnew = this.aliases.get(entry.getKey());
            if (tnew != null && tnew == tprev) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return Iterables.any(this.aliases.values(), t -> t.referencesUserType(name, accessor));
    }

    public DynamicCompositeType withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        instances.remove(this.aliases);
        return DynamicCompositeType.getInstance(Maps.transformValues(this.aliases, v -> v.withUpdatedUserType(udt)));
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return DynamicCompositeType.getInstance(Maps.transformValues(this.aliases, v -> v.expandUserTypes()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicCompositeType that = (DynamicCompositeType)o;
        return this.aliases.equals(that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.aliases);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyAliasesParameters(this.aliases);
    }

    @VisibleForTesting
    public static class FixedValueComparator
    extends AbstractType<Void> {
        public static final FixedValueComparator alwaysLesserThan = new FixedValueComparator(-1);
        public static final FixedValueComparator alwaysGreaterThan = new FixedValueComparator(1);
        private final int cmp;

        public FixedValueComparator(int cmp) {
            super(AbstractType.ComparisonType.CUSTOM);
            this.cmp = cmp;
        }

        @Override
        public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
            return this.cmp;
        }

        @Override
        public <V> Void compose(V value, ValueAccessor<V> accessor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer decompose(Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> String getString(V value, ValueAccessor<V> accessor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer fromString(String str) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Term fromJSONObject(Object parsed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void validate(ByteBuffer bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeSerializer<Void> getSerializer() {
            throw new UnsupportedOperationException();
        }
    }

    private class DynamicParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final boolean isAlias;
        final String comparatorName;
        final String remainingPart;

        DynamicParsedComparator(String part) {
            String[] splits = part.split("@");
            switch (splits.length) {
                default: {
                    throw new IllegalArgumentException("Invalid component representation: " + part);
                }
                case 1: {
                    this.comparatorName = splits[0];
                    this.remainingPart = "";
                    break;
                }
                case 2: {
                    this.comparatorName = splits[0];
                    this.remainingPart = splits[1];
                }
            }
            try {
                AbstractType<?> t = null;
                if (this.comparatorName.length() == 1) {
                    t = DynamicCompositeType.this.aliases.get((byte)this.comparatorName.charAt(0));
                }
                boolean bl = this.isAlias = t != null;
                if (!this.isAlias) {
                    t = TypeParser.parse(this.comparatorName);
                }
                this.type = t;
            }
            catch (ConfigurationException | SyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.remainingPart;
        }

        @Override
        public int getComparatorSerializedSize() {
            return this.isAlias ? 2 : 2 + ByteBufferUtil.bytes(this.comparatorName).remaining();
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
            int header = 0;
            header = this.isAlias ? 0x8000 | (byte)this.comparatorName.charAt(0) & 0xFF : this.comparatorName.length();
            ByteBufferUtil.writeShortLength(bb, header);
            if (!this.isAlias) {
                bb.put(ByteBufferUtil.bytes(this.comparatorName));
            }
        }
    }

    public static class Serializer
    extends BytesSerializer {
        private final Map<Byte, AbstractType<?>> aliases;

        public Serializer(Map<Byte, AbstractType<?>> aliases) {
            this.aliases = aliases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Serializer that = (Serializer)o;
            return this.aliases.equals(that.aliases);
        }

        public int hashCode() {
            return Objects.hash(this.aliases);
        }
    }
}

