/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Comparables;

public class Slice {
    public static final Serializer serializer = new Serializer();
    public static final Slice ALL = new Slice(BufferClusteringBound.BOTTOM, BufferClusteringBound.TOP){

        @Override
        public boolean includes(ClusteringComparator comparator, ClusteringPrefix<?> clustering) {
            return true;
        }

        @Override
        public boolean intersects(ClusteringComparator comparator, Slice other) {
            return !other.isEmpty(comparator);
        }

        @Override
        public String toString(ClusteringComparator comparator) {
            return "ALL";
        }
    };
    private final ClusteringBound<?> start;
    private final ClusteringBound<?> end;

    private Slice(ClusteringBound<?> start, ClusteringBound<?> end) {
        assert (start.isStart() && end.isEnd());
        this.start = start;
        this.end = end;
    }

    public static Slice make(ClusteringBound<?> start, ClusteringBound<?> end) {
        assert (start != null && end != null);
        if (start.isBottom() && end.isTop()) {
            return ALL;
        }
        return new Slice(start, end);
    }

    public static Slice make(ClusteringComparator comparator, Object ... values) {
        CBuilder builder = CBuilder.create(comparator);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return new Slice(builder.buildBound(true, true), builder.buildBound(false, true));
    }

    public static Slice make(Clustering<?> clustering) {
        assert (clustering != Clustering.STATIC_CLUSTERING);
        return new Slice(ClusteringBound.inclusiveStartOf(clustering), ClusteringBound.inclusiveEndOf(clustering));
    }

    public static Slice make(Clustering<?> start, Clustering<?> end) {
        assert (start != Clustering.STATIC_CLUSTERING && end != Clustering.STATIC_CLUSTERING);
        return new Slice(ClusteringBound.inclusiveStartOf(start), ClusteringBound.inclusiveEndOf(end));
    }

    public static Slice make(ClusteringBoundOrBoundary<?> start, ClusteringBoundOrBoundary<?> end) {
        return Slice.make(start.asStartBound(), end.asEndBound());
    }

    public ClusteringBound<?> start() {
        return this.start;
    }

    public ClusteringBound<?> end() {
        return this.end;
    }

    public ClusteringBound<?> open(boolean reversed) {
        return reversed ? this.end : this.start;
    }

    public ClusteringBound<?> close(boolean reversed) {
        return reversed ? this.start : this.end;
    }

    public boolean isEmpty(ClusteringComparator comparator) {
        return Slice.isEmpty(comparator, this.start(), this.end());
    }

    public static boolean isEmpty(ClusteringComparator comparator, ClusteringBound<?> start, ClusteringBound<?> end) {
        assert (start.isStart() && end.isEnd());
        return comparator.compare(start, end) >= 0;
    }

    public boolean includes(ClusteringComparator comparator, ClusteringPrefix<?> bound) {
        return comparator.compare(this.start, bound) <= 0 && comparator.compare(bound, this.end) <= 0;
    }

    public Slice forPaging(ClusteringComparator comparator, Clustering<?> lastReturned, boolean inclusive, boolean reversed) {
        if (lastReturned == null) {
            return this;
        }
        if (reversed) {
            int cmp = comparator.compare(lastReturned, this.start);
            assert (cmp != 0);
            if (cmp < 0) {
                return null;
            }
            cmp = comparator.compare(this.end, lastReturned);
            assert (cmp != 0);
            if (cmp < 0) {
                return this;
            }
            Slice slice = new Slice(this.start, inclusive ? ClusteringBound.inclusiveEndOf(lastReturned) : ClusteringBound.exclusiveEndOf(lastReturned));
            if (slice.isEmpty(comparator)) {
                return null;
            }
            return slice;
        }
        int cmp = comparator.compare(this.end, lastReturned);
        assert (cmp != 0);
        if (cmp < 0) {
            return null;
        }
        cmp = comparator.compare(lastReturned, this.start);
        assert (cmp != 0);
        if (cmp < 0) {
            return this;
        }
        Slice slice = new Slice(inclusive ? ClusteringBound.inclusiveStartOf(lastReturned) : ClusteringBound.exclusiveStartOf(lastReturned), this.end);
        if (slice.isEmpty(comparator)) {
            return null;
        }
        return slice;
    }

    public boolean intersects(ClusteringComparator comparator, Slice other) {
        return comparator.compare((ClusteringPrefix)Comparables.max(this.start, other.start, comparator), (ClusteringPrefix)Comparables.min(this.end, other.end, comparator)) < 0;
    }

    public String toString(ClusteringComparator comparator) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.start.isInclusive() ? "[" : "(");
        for (i = 0; i < this.start.size(); ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(this.start.stringAt(i, comparator));
        }
        sb.append(", ");
        for (i = 0; i < this.end.size(); ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(this.end.stringAt(i, comparator));
        }
        sb.append(this.end.isInclusive() ? "]" : ")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Slice)) {
            return false;
        }
        Slice that = (Slice)other;
        return this.start().equals(that.start()) && this.end().equals(that.end());
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public static class Serializer {
        public void serialize(Slice slice, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            ClusteringBound.serializer.serialize(slice.start, out, version, types);
            ClusteringBound.serializer.serialize(slice.end, out, version, types);
        }

        public long serializedSize(Slice slice, int version, List<AbstractType<?>> types) {
            return ClusteringBound.serializer.serializedSize(slice.start, version, types) + ClusteringBound.serializer.serializedSize(slice.end, version, types);
        }

        public Slice deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            ClusteringBound start = (ClusteringBound)ClusteringBound.serializer.deserialize(in, version, types);
            ClusteringBound end = (ClusteringBound)ClusteringBound.serializer.deserialize(in, version, types);
            return new Slice(start, end);
        }
    }
}

