/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.Input;
import org.apache.trevni.InputFile;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.avro.AvroColumnator;

public class AvroColumnReader<D>
implements Iterator<D>,
Iterable<D>,
Closeable {
    private ColumnFileReader reader;
    private GenericData model;
    private Schema fileSchema;
    private Schema readSchema;
    private ColumnValues[] values;
    private int[] arrayWidths;
    private int column;
    private Map<String, Map<String, Object>> defaults = new HashMap<String, Map<String, Object>>();

    public AvroColumnReader(Params params) throws IOException {
        this.reader = new ColumnFileReader(params.input);
        this.model = params.model;
        this.fileSchema = new Schema.Parser().parse(this.reader.getMetaData().getString("avro.schema"));
        this.readSchema = params.schema == null ? this.fileSchema : params.schema;
        this.initialize();
    }

    public Schema getFileSchema() {
        return this.fileSchema;
    }

    void initialize() throws IOException {
        HashMap<String, Integer> fileColumnNumbers = new HashMap<String, Integer>();
        int i = 0;
        for (ColumnMetaData c : new AvroColumnator(this.fileSchema).getColumns()) {
            fileColumnNumbers.put(c.getName(), i++);
        }
        AvroColumnator readColumnator = new AvroColumnator(this.readSchema);
        this.arrayWidths = readColumnator.getArrayWidths();
        ColumnMetaData[] readColumns = readColumnator.getColumns();
        this.values = new ColumnValues[readColumns.length];
        int j = 0;
        for (ColumnMetaData c : readColumns) {
            Integer n = (Integer)fileColumnNumbers.get(c.getName());
            if (n == null) continue;
            this.values[j++] = this.reader.getValues(n);
        }
        this.findDefaults(this.readSchema, this.fileSchema);
    }

    private void findDefaults(Schema read, Schema write) {
        switch (read.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: 
            case STRING: 
            case ENUM: 
            case FIXED: {
                if (read.getType() == write.getType()) break;
                throw new TrevniRuntimeException("Type mismatch: " + read + " & " + write);
            }
            case MAP: {
                this.findDefaults(read.getValueType(), write.getValueType());
                break;
            }
            case ARRAY: {
                this.findDefaults(read.getElementType(), write.getElementType());
                break;
            }
            case UNION: {
                for (Schema s2 : read.getTypes()) {
                    Integer index = write.getIndexNamed(s2.getFullName());
                    if (index == null) {
                        throw new TrevniRuntimeException("No matching branch: " + s2);
                    }
                    this.findDefaults(s2, write.getTypes().get(index));
                }
                break;
            }
            case RECORD: {
                for (Schema.Field f : read.getFields()) {
                    Schema.Field g2 = write.getField(f.name());
                    if (g2 == null) {
                        this.setDefault(read, f);
                        continue;
                    }
                    this.findDefaults(f.schema(), g2.schema());
                }
                break;
            }
            default: {
                throw new TrevniRuntimeException("Unknown schema: " + read);
            }
        }
    }

    private void setDefault(Schema record, Schema.Field f) {
        String recordName = record.getFullName();
        Map recordDefaults = this.defaults.computeIfAbsent(recordName, k -> new HashMap());
        recordDefaults.put(f.name(), this.model.getDefaultValue(f));
    }

    @Override
    public Iterator<D> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.values[0].hasNext();
    }

    public long getRowCount() {
        return this.reader.getRowCount();
    }

    @Override
    public D next() {
        try {
            for (ColumnValues value : this.values) {
                if (value == null) continue;
                value.startRow();
            }
            this.column = 0;
            return (D)this.read(this.readSchema);
        }
        catch (IOException e) {
            throw new TrevniRuntimeException(e);
        }
    }

    private Object read(Schema s2) throws IOException {
        if (AvroColumnator.isSimple(s2)) {
            return this.nextValue(s2, this.column++);
        }
        int startColumn = this.column;
        switch (s2.getType()) {
            case MAP: {
                int size = this.values[this.column].nextLength();
                HashMap<String, Object> map = new HashMap<String, Object>(size);
                for (int i = 0; i < size; ++i) {
                    this.column = startColumn;
                    this.values[this.column++].nextValue();
                    String key = (String)this.values[this.column++].nextValue();
                    map.put(key, this.read(s2.getValueType()));
                }
                this.column = startColumn + this.arrayWidths[startColumn];
                return map;
            }
            case RECORD: {
                Object record = this.model.newRecord(null, s2);
                Map<String, Object> rDefaults = this.defaults.get(s2.getFullName());
                for (Schema.Field f : s2.getFields()) {
                    Object value = rDefaults != null && rDefaults.containsKey(f.name()) ? this.model.deepCopy(f.schema(), rDefaults.get(f.name())) : this.read(f.schema());
                    this.model.setField(record, f.name(), f.pos(), value);
                }
                return record;
            }
            case ARRAY: {
                int length = this.values[this.column].nextLength();
                GenericData.Array elements = new GenericData.Array(length, s2);
                for (int i = 0; i < length; ++i) {
                    this.column = startColumn;
                    Object value = this.nextValue(s2, this.column++);
                    if (!AvroColumnator.isSimple(s2.getElementType())) {
                        value = this.read(s2.getElementType());
                    }
                    elements.add(value);
                }
                this.column = startColumn + this.arrayWidths[startColumn];
                return elements;
            }
            case UNION: {
                Object value = null;
                for (Schema branch : s2.getTypes()) {
                    if (branch.getType() == Schema.Type.NULL) continue;
                    if (this.values[this.column].nextLength() == 1) {
                        value = this.nextValue(branch, this.column);
                        ++this.column;
                        if (AvroColumnator.isSimple(branch)) continue;
                        value = this.read(branch);
                        continue;
                    }
                    this.column += this.arrayWidths[this.column];
                }
                return value;
            }
        }
        throw new TrevniRuntimeException("Unknown schema: " + s2);
    }

    private Object nextValue(Schema s2, int column) throws IOException {
        Object v = this.values[column].nextValue();
        switch (s2.getType()) {
            case ENUM: {
                return this.model.createEnum(s2.getEnumSymbols().get((Integer)v), s2);
            }
            case FIXED: {
                return this.model.createFixed(null, ((ByteBuffer)v).array(), s2);
            }
        }
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static class Params {
        Input input;
        Schema schema;
        GenericData model = GenericData.get();

        public Params(File file) throws IOException {
            this(new InputFile(file));
        }

        public Params(Input input) {
            this.input = input;
        }

        public Params setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Params setModel(GenericData model) {
            this.model = model;
            return this;
        }
    }
}

