/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.runningaggregates.std;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.runningaggregates.std.AbstractRankRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

class PercentRankRunningAggregateEvaluator
extends AbstractRankRunningAggregateEvaluator {
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private final ISerializerDeserializer<ADouble> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private double divisor;

    PercentRankRunningAggregateEvaluator(IScalarEvaluator[] args, SourceLocation sourceLoc) {
        super(args, false, sourceLoc);
    }

    @Override
    public void initPartition(long partitionLength) {
        super.initPartition(partitionLength);
        this.divisor = (double)partitionLength - 1.0;
    }

    @Override
    protected void computeResult(DataOutput out) throws HyracksDataException {
        double percentRank = this.first ? 0.0 : (double)(this.rank - 1L) / this.divisor;
        this.aDouble.setValue(percentRank);
        this.serde.serialize((Object)this.aDouble, out);
    }
}

