/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class AggregateFunctionCallExpression
extends AbstractFunctionCallExpression {
    private boolean twoStep;
    private IFunctionInfo stepOneAggregate;
    private IFunctionInfo stepTwoAggregate;

    public AggregateFunctionCallExpression(IFunctionInfo finfo, boolean isTwoStep, List<Mutable<ILogicalExpression>> arguments) {
        super(AbstractFunctionCallExpression.FunctionKind.AGGREGATE, finfo, arguments);
        this.twoStep = isTwoStep;
    }

    public boolean isTwoStep() {
        return this.twoStep;
    }

    @Override
    public AggregateFunctionCallExpression cloneExpression() {
        List<Mutable<ILogicalExpression>> clonedArgs = this.cloneArguments();
        AggregateFunctionCallExpression fun = new AggregateFunctionCallExpression(this.finfo, this.twoStep, clonedArgs);
        fun.setStepTwoAggregate(this.stepTwoAggregate);
        fun.setStepOneAggregate(this.stepOneAggregate);
        fun.setSourceLocation(this.sourceLoc);
        fun.setOpaqueParameters(this.getOpaqueParameters());
        this.copyAnnotationsInto(fun);
        return fun;
    }

    public void setStepOneAggregate(IFunctionInfo stepOneAggregate) {
        this.stepOneAggregate = stepOneAggregate;
    }

    public IFunctionInfo getStepOneAggregate() {
        return this.stepOneAggregate;
    }

    public void setStepTwoAggregate(IFunctionInfo stepTwoAggregate) {
        this.stepTwoAggregate = stepTwoAggregate;
    }

    public IFunctionInfo getStepTwoAggregate() {
        return this.stepTwoAggregate;
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitAggregateFunctionCallExpression(this, arg);
    }
}

