/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetaRecoveryContext {
    public static final Log LOG = LogFactory.getLog(MetaRecoveryContext.class.getName());
    private int force;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_FIRST_CHOICE = 1;
    public static final int FORCE_ALL = 2;

    public MetaRecoveryContext(int force) {
        this.force = force;
    }

    public String ask(String prompt, String firstChoice, String ... choices) throws IOException {
        while (true) {
            int c;
            LOG.error(prompt);
            if (this.force > 0) {
                LOG.info("Automatically choosing " + firstChoice);
                return firstChoice;
            }
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            String response = responseBuilder.toString();
            if (response.equalsIgnoreCase(firstChoice)) {
                return firstChoice;
            }
            for (String c2 : choices) {
                if (!response.equalsIgnoreCase(c2)) continue;
                return c2;
            }
            LOG.error("I'm sorry, I cannot understand your response.\n");
        }
    }

    public void quit() {
        LOG.error("Exiting on user request.");
        System.exit(0);
    }

    public static void editLogLoaderPrompt(String prompt, MetaRecoveryContext recovery) throws IOException {
        if (recovery == null) {
            throw new IOException(prompt);
        }
        LOG.error(prompt);
        String answer = recovery.ask("\nEnter 's' to stop reading the edit log here, abandoning any later edits.\nEnter 'q' to quit without saving.\n(s/q)", "s", "q");
        if (answer.equals("s")) {
            LOG.error("We will stop reading the edits log here.  NOTE: Some edits have been lost!");
            return;
        }
        if (answer.equals("q")) {
            recovery.quit();
        }
    }
}

