#!/usr/bin/env python
"""
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

"""

import sys
from resource_management.libraries.script import Script
from resource_management.core.resources.system import Execute

class HbaseMasterUpgrade(Script):

  def take_snapshot(self, env):
    import params

    snap_cmd = "echo 'snapshot_all' | {0} shell".format(params.hbase_cmd)

    exec_cmd = "{0} {1}".format(params.kinit_cmd, snap_cmd)

    Execute(exec_cmd, user=params.hbase_user)

  def restore_snapshot(self, env):
    import params
    print "TODO AMBARI-12698"

if __name__ == "__main__":
  HbaseMasterUpgrade().execute()
