/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.ObjectFactory;
import org.apache.xml.utils.WrappedRuntimeException;

public class ObjectPool
implements Serializable {
    static final long serialVersionUID = -8519013691660936643L;
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new Vector();
    }

    public ObjectPool(String string) {
        try {
            this.objectType = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
        this.freeStack = new Vector();
    }

    public ObjectPool(Class clazz, int n) {
        this.objectType = clazz;
        this.freeStack = new Vector(n);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object e = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return e;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object e = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return e;
    }

    public synchronized void freeInstance(Object object) {
        this.freeStack.addElement(object);
    }
}

