/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.Program;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.JavaC;
import com.ibm.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xylem.drivers.IXylemDriver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    static final Logger s_logger;
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();

    public static int parseOptions(XSLTLinkerSettings xSLTLinkerSettings, String[] stringArray, int n, Logger logger) {
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("\t[-outputdir dir]\n\t[-enabletracing]\n\t[-dumpxylem]\n\t[-dumpintermediatexylem]\n\t[-detectoverlap]\n\t[-classloaderproxy]");
            xSLTLinkerSettings.getCodeGenerationSettings().parseOption(stringArray, n);
            return -1;
        }
        if ("-classLoaderProxy".equals(stringArray[n])) {
            xSLTLinkerSettings.setGenerateClassLoadingProxy(true);
            return n;
        }
        if ("-detectoverlap".equals(stringArray[n])) {
            xSLTLinkerSettings.setOverlapDetection(true);
            return n;
        }
        if ("-dumpintermediatexylem".equals(stringArray[n])) {
            xSLTLinkerSettings.setDumpIntermediateXylem(true);
            return n;
        }
        if ("-dumpxylem".equals(stringArray[n])) {
            xSLTLinkerSettings.setDumpXylem(true);
            return n;
        }
        if ("-enabletracing".equals(stringArray[n])) {
            xSLTLinkerSettings.getCodeGenerationSettings().setFunctionCallTracing(true);
            return n;
        }
        if ("-outputdir".equals(stringArray[n])) {
            if (++n == stringArray.length) {
                logger.error("-outputdir missing parameter");
                return -1;
            }
            File file = new File(stringArray[n]);
            xSLTLinkerSettings.setOutputDir(file);
            if (!file.exists() || !file.isDirectory()) {
                logger.error("specified output directory does not exist or is not a directory: " + file);
                return -1;
            }
            return n;
        }
        return xSLTLinkerSettings.getCodeGenerationSettings().parseOption(stringArray, n);
    }

    public static void main(String[] stringArray) {
        Linker linker;
        CLP cLP = new CLP();
        cLP.m_linker = linker = new Linker();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        try {
            File file;
            if (cLP.m_files.size() > 1 || cLP.m_linkerSettings.isOverlapDetection()) {
                s_logger.error("multiple XSLT input files/-functor/-overlapdetection not yet supported");
                System.exit(-1);
            }
            if ((file = linker.linkFiles(cLP.m_files, cLP.m_classNames, null, null, 0, cLP)) != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File linkFiles(List list, List list2, String string, Collection collection, int n, CLP cLP) {
        Module module;
        LinkedList<Module> linkedList = new LinkedList<Module>();
        Iterator iterator = list.iterator();
        try {
            s_logger.info("Compiling, and obtaining signature for, runtime library");
            boolean bl = cLP.m_version.equals("1.0");
            module = bl ? XSLTCompiler.compileRuntimeLibrary("1.0") : XSLTCompiler.compileRuntimeLibrary("2.0");
            Program program = new Program();
            program.addModule(module);
            String string2 = module.getName();
            this.m_mss.registerModuleSignature(string2, program.getModuleSignature(string2));
        }
        catch (Exception exception) {
            s_logger.error("!", exception);
            throw new Error();
        }
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            s_logger.info("linking " + uRL.getPath());
            try {
                module = Module.loadCompiled(uRL, this.m_mss);
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.error("!", exception);
                throw new Error();
            }
        }
        return this.linkModules(linkedList, list2, string, collection, n, cLP);
    }

    public File linkModules(List list, List list2, String string, Collection collection, int n, CLP cLP) {
        try {
            boolean bl = cLP.m_version.equals("1.0");
            Module module = bl ? XSLTCompiler.compileRuntimeLibrary("1.0") : XSLTCompiler.compileRuntimeLibrary("2.0");
            Module module2 = (Module)list.get(0);
            String string2 = module2.getName();
            XSLTLinker.compileProgram(module2, module, 1, string2 == null ? Collections.EMPTY_LIST : Collections.singletonList(string2), cLP.m_linkerSettings);
            File file = new File(module2.getName());
            if (file == null || !file.exists()) {
                System.exit(-1);
            }
            return file;
        }
        catch (Exception exception) {
            s_logger.error("linkModules failure\n", exception);
            System.exit(-1);
            return null;
        }
    }

    protected void desugar(Program program) {
        new PolymorphicADTDesugarer(program).desugar();
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(Linker.class);
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_version = "1.0";
        public ArrayList m_classNames = new ArrayList();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(new XSLTCompilerSettings());

        @Override
        protected int parseOption(String[] stringArray, int n) {
            if (n == 0) {
                this.m_linkerSettings.setCodeGenSettings(this.m_linker.m_codeGenerationSettings);
            }
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]");
                Linker.parseOptions(this.m_linkerSettings, stringArray, n, s_logger);
                System.out.println("\t[-version (1.0 | 2.0)\n");
                System.out.println("\t[-classname name-of-compiled-class]");
                super.parseOption(stringArray, n);
                System.out.println("Input file should be *.cxo");
                return -1;
            }
            if (stringArray[n].equals("-classname")) {
                if (++n == stringArray.length) {
                    s_logger.error("-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(stringArray[n]);
                return n;
            }
            if (stringArray[n].equals("-version")) {
                if (++n == stringArray.length) {
                    s_logger.error("-version missing parameter");
                    return -1;
                }
                this.m_version = stringArray[n];
                return n;
            }
            if (stringArray[n].equals("-javac")) {
                s_logger.info("-javac is now default; use -disablejavac to suppress");
                return n;
            }
            int n2 = this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n);
            if (n2 == -1) {
                return -1;
            }
            if (n2 != -2) {
                return n2;
            }
            return super.parseOption(stringArray, n);
        }
    }
}

