/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.utils;

import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.ErrorHandler;
import com.ibm.xtq.common.utils.SourceLocation;
import java.util.Vector;

public class Reporter {
    private boolean _debug = true;
    private boolean _reportImmediately = true;
    private ErrorHandler _errorHandler;
    private boolean _dieOnError = false;
    private Vector _errors = new Vector();
    private Vector _warnings = new Vector();
    private boolean _hasErrors = false;

    public void reset() {
        this._errors.removeAllElements();
        this._warnings.removeAllElements();
        this._hasErrors = false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public boolean errorsFound() {
        return this._hasErrors || this._errors.size() > 0;
    }

    public void printErrors() {
        int n = this._errors.size();
        if (n > 0) {
            System.err.println(new ASTMsg("ERR_SYSTEM", "Compiler errors."));
            for (int i = 0; i < n; ++i) {
                System.err.println("  " + this._errors.elementAt(i));
            }
            this._errors.clear();
        }
    }

    public void printWarnings() {
        int n = this._warnings.size();
        if (n > 0) {
            System.err.println(new ASTMsg("COMPILER_WARNING_KEY"));
            for (int i = 0; i < n; ++i) {
                System.err.println("  " + this._warnings.elementAt(i));
            }
            this._warnings.clear();
        }
    }

    public void _assert(String string) {
        ASTMsg aSTMsg = new ASTMsg(new RuntimeException(string));
        this.report(0, aSTMsg);
    }

    public void _assert(boolean bl) {
        if (!bl) {
            Throwable throwable = new Throwable("Programmers Assertion Failed!");
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(boolean bl, Throwable throwable) {
        if (!bl) {
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(boolean bl, SimpleNode simpleNode) {
        if (!bl) {
            Throwable throwable = new Throwable("\nProblem with: " + simpleNode.getClass().getName() + "! \nLine #" + simpleNode.getLineNumber() + " type: " + XPathTreeConstants.jjtNodeName[simpleNode.getId()]);
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(Throwable throwable) {
        ASTMsg aSTMsg = new ASTMsg(throwable);
        this.report(0, aSTMsg);
    }

    public void assertNotImplemented(Throwable throwable) {
        ASTMsg aSTMsg = new ASTMsg(throwable);
        this.report(0, aSTMsg);
    }

    public void report(int n, ASTBaseMsg aSTBaseMsg) {
        if (this._errorHandler != null) {
            String string = aSTBaseMsg.getFormattedMessage();
            SourceLocation sourceLocation = aSTBaseMsg.getSourceLocation();
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this._errorHandler.report(2, string, sourceLocation, null, true);
                    this._hasErrors = true;
                    break;
                }
                case 3: {
                    this._errorHandler.report(1, string, sourceLocation, null, false);
                    this._hasErrors = true;
                    break;
                }
                case 4: {
                    this._errorHandler.report(0, string, sourceLocation, null, false);
                    break;
                }
                case 5: {
                    this._errorHandler.report(1, string, sourceLocation, null, false);
                }
            }
            return;
        }
        switch (n) {
            case 0: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 1: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 2: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 3: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 4: {
                this._warnings.addElement(aSTBaseMsg);
            }
        }
        if (this.isReportImmediately()) {
            RuntimeException runtimeException = new RuntimeException(aSTBaseMsg.toString());
            if (this.isDieOnError() && n != 4 || n == 2) {
                if (this._errors.size() > 1) {
                    this.printErrors();
                }
                if (this._warnings.size() > 1) {
                    this.printWarnings();
                }
                throw runtimeException;
            }
            if (this.isDebug() && n != 4) {
                if (this._errors.size() > 1) {
                    this.printErrors();
                }
                if (this._warnings.size() > 1) {
                    this.printWarnings();
                }
                runtimeException.printStackTrace();
            } else {
                if (this._errors.size() > 0) {
                    this.printErrors();
                }
                if (this._warnings.size() > 0) {
                    this.printWarnings();
                }
            }
        }
    }

    public Vector getErrors() {
        return this._errors;
    }

    public Vector getWarnings() {
        return this._warnings;
    }

    public boolean isReportImmediately() {
        return this._reportImmediately;
    }

    public void setReportImmediately(boolean bl) {
        this._reportImmediately = bl;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public boolean isDieOnError() {
        return this._dieOnError;
    }

    public void setDieOnError(boolean bl) {
        this._dieOnError = bl;
    }
}

