/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.ILocalDRPC;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.drpc.DRPCSpout;
import backtype.storm.drpc.ReturnResults;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;

public class ManualDRPC {
    public static void main(String[] args) {
        TopologyBuilder builder = new TopologyBuilder();
        LocalDRPC drpc = new LocalDRPC();
        DRPCSpout spout = new DRPCSpout("exclamation", (ILocalDRPC)drpc);
        builder.setSpout("drpc", (IRichSpout)spout);
        builder.setBolt("exclaim", (IBasicBolt)new ExclamationBolt(), (Number)3).shuffleGrouping("drpc");
        builder.setBolt("return", (IRichBolt)new ReturnResults(), (Number)3).shuffleGrouping("exclaim");
        LocalCluster cluster = new LocalCluster();
        Config conf = new Config();
        cluster.submitTopology("exclaim", (Map)conf, builder.createTopology());
        System.out.println(drpc.execute("exclamation", "aaa"));
        System.out.println(drpc.execute("exclamation", "bbb"));
    }

    public static class ExclamationBolt
    extends BaseBasicBolt {
        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"result", "return-info"}));
        }

        public void execute(Tuple tuple, BasicOutputCollector collector) {
            String arg = tuple.getString(0);
            Object retInfo = tuple.getValue(1);
            collector.emit((List)new Values(new Object[]{arg + "!!!", retInfo}));
        }
    }
}

