/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xpath.jaxp.XPathImpl;
import org.apache.xpath.res.XPATHMessages;

public class XPathFactoryImpl
extends XPathFactory {
    public static final String FEATURE_NULL_FCN_PREFIX = "null_function_prefix";
    private boolean m_isSecureProcessing = false;
    private boolean m_allowNullFcnPrefix = false;
    private XPathVariableResolver m_variableResolver = null;
    private XPathFunctionResolver m_functionResolver = null;

    @Override
    public boolean isObjectModelSupported(String string) {
        if (string == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_OBJECT_MODEL_NULL", null));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_OBJECT_MODEL_EMPTY", null));
        }
        return string.equals("http://java.sun.com/jaxp/xpath/dom");
    }

    @Override
    public void setFeature(String string, boolean bl) throws XPathFactoryConfigurationException {
        if (string == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_SET_FEATURE_NULL_NAME", null));
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.m_isSecureProcessing = bl;
        } else if (string.equals(FEATURE_NULL_FCN_PREFIX)) {
            this.m_allowNullFcnPrefix = bl;
        } else {
            throw new XPathFactoryConfigurationException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_FEATURE", new Object[]{string}));
        }
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    public boolean allowNullFcnPrefix() {
        return this.m_allowNullFcnPrefix;
    }

    @Override
    public boolean getFeature(String string) throws XPathFactoryConfigurationException {
        if (string == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_GET_FEATURE_NULL_NAME", null));
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.m_isSecureProcessing;
        }
        if (string.equals(FEATURE_NULL_FCN_PREFIX)) {
            return this.m_allowNullFcnPrefix;
        }
        throw new XPathFactoryConfigurationException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_FEATURE", new Object[]{string}));
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", null));
        }
        this.m_variableResolver = xPathVariableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", null));
        }
        this.m_functionResolver = xPathFunctionResolver;
    }

    @Override
    public XPath newXPath() {
        XPathImpl xPathImpl = new XPathImpl(this.m_functionResolver, this.m_variableResolver, this.m_isSecureProcessing, this.m_allowNullFcnPrefix);
        return xPathImpl;
    }
}

