/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.utils.XylemError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InterpreterUtilities {
    private boolean debugging = false;
    public static final boolean tailCallEliminationEnabled = true;

    public void setDebuggerflag(boolean bl) {
        this.debugging = bl;
    }

    public boolean getDebuggerflag() {
        return this.debugging;
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length && method == null; ++i) {
                Class<?>[] classArray2;
                Method method2 = methodArray[i];
                if (!method2.getName().equals(string) || (classArray2 = method2.getParameterTypes()).length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray2.length && bl; ++j) {
                    if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                method = method2;
            }
        }
        if (method == null) {
            throw new XylemError("ERR_SYSTEM", "Method not found: class = " + clazz + " method = " + string + " args = " + Arrays.asList(classArray));
        }
        return method;
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        Constructor<Object> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null) {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length && constructor == null; ++i) {
                Constructor<?> constructor2 = constructorArray[i];
                Class<?>[] classArray2 = constructor2.getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray2.length && bl; ++j) {
                    if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                constructor = constructor2;
            }
        }
        if (constructor == null) {
            throw new XylemError("ERR_SYSTEM", "Constructor not found: class = " + clazz + " args = " + classArray);
        }
        return constructor;
    }
}

