/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;

public class FunctionSignature {
    protected String m_functionName;
    protected Type m_returnType;
    protected Type[] m_parameterTypes;
    protected Object[] m_parameterNames;
    public String[] m_defaultValues;

    public FunctionSignature() {
    }

    public FunctionSignature(String string, Object[] objectArray, Type[] typeArray, Type type) {
        this.m_functionName = string;
        if (this.m_functionName == null) {
            throw new NullPointerException();
        }
        this.m_parameterTypes = typeArray;
        this.m_parameterNames = objectArray;
        this.m_returnType = type;
    }

    public FunctionSignature(Function function) {
        this.m_functionName = function.getName();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_returnType = function.getReturnType();
        Binding[] bindingArray = function.m_parameters;
        this.m_parameterTypes = new Type[bindingArray.length];
        this.m_parameterNames = new Object[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            this.m_parameterTypes[i] = bindingArray[i].getBindingType();
            this.m_parameterNames[i] = bindingArray[i].getName();
        }
        if (function.m_defaultValues != null) {
            this.m_defaultValues = (String[])function.m_defaultValues.clone();
        }
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public void setFunctionName(String string) {
        this.m_functionName = string;
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type type) {
        this.m_returnType = type;
    }

    public Type[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public Object[] getParameterNames() {
        return this.m_parameterNames;
    }

    public void setParameterType(int n, Type type) {
        this.m_parameterTypes[n] = type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.m_functionName);
        if (this.m_returnType != null) {
            stringBuffer.append("@");
            stringBuffer.append(this.m_returnType.prettyPrint());
        }
        int n = this.m_parameterTypes.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(PrettyPrinter.prettyPrintIdentifier(this.m_parameterNames[i]));
            stringBuffer.append('@');
            stringBuffer.append(this.m_parameterTypes[i].prettyPrint());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("declare-function", n);
        prettyPrinter.printToken(this.m_functionName, n + 1);
        if (this.m_returnType != null) {
            prettyPrinter.print("@");
            prettyPrinter.print(this.m_returnType.prettyPrint());
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            prettyPrinter.printIdentifier(this.m_parameterNames[i], n + 1);
            Type type = this.m_parameterTypes[i];
            prettyPrinter.print("@");
            prettyPrinter.print(type.prettyPrint());
        }
        prettyPrinter.printFormClose(n);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature functionSignature = (FunctionSignature)object;
        if (!functionSignature.m_functionName.equals(this.m_functionName) || functionSignature.m_parameterTypes.length != this.m_parameterTypes.length) {
            return false;
        }
        if (this.m_returnType == null && functionSignature.m_returnType != null || functionSignature.m_returnType == null && this.m_returnType != null) {
            return false;
        }
        if (this.m_returnType != functionSignature.m_returnType && !this.m_returnType.equals(functionSignature.m_returnType)) {
            return false;
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            if (this.m_parameterTypes[i].equals(functionSignature.m_parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_functionName.hashCode() + this.m_parameterTypes.length;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        writeObjectFileHelper.writeString(this.m_functionName);
        writeObjectFileHelper.writeBindingNames(this.m_parameterNames);
        writeObjectFileHelper.writeTypes(this.m_parameterTypes);
        writeObjectFileHelper.writeType(this.m_returnType);
        writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                writeObjectFileHelper.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_functionName = readObjectFileHelper.readString();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_parameterNames = readObjectFileHelper.readBindingNames();
        this.m_parameterTypes = readObjectFileHelper.readTypes();
        this.m_returnType = readObjectFileHelper.readType();
        int n = readObjectFileHelper.readInt();
        if (n > 0) {
            this.m_defaultValues = new String[n];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!readObjectFileHelper.readBoolean()) continue;
                this.m_defaultValues[i] = readObjectFileHelper.readString();
            }
        }
    }
}

