/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.common.utils.ErrorHandler;
import com.ibm.xtq.common.utils.ErrorHandlerProvider;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.translator.FunctionOperatorHelper;
import com.ibm.xtq.xslt.translator.FunctionOperatorTable;
import com.ibm.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xtq.xslt.translator.SimpleFunctionDeclaration;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.utils.SourceLocation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;

public class XPathCompiler
implements ErrorHandlerProvider {
    protected XSLTParser _parser;
    private int _nextGType;
    private ArrayList _namesIndex;
    private Hashtable _elements;
    private Hashtable _attributes;
    private Hashtable _namespaceDecls;
    private int _nextNSType;
    private ArrayList _namespaceIndex;
    private Hashtable _namespaces;
    private int _stepPatternSerial = 1;
    private boolean _staticTyping = false;
    private String _xpathVersion = "1.0";
    private boolean _hasIdCall = false;
    private boolean _callsNodeset = false;
    private static final int SIMPLE = 0;
    private static final int POLYMORPHIC = 1;
    private static final int OPERATOR = 2;
    private static final int XTQHP = 3;
    private FunctionOperatorTable funcTable = FunctionOperatorTable.getInstance();
    private final String[] OPERATOR_NAMES = new String[]{"add", "subtract", "multiply", "div", "idiv", "mod", "eq", "ne", "gt", "lt", "ge", "le", "unary-minus", "unary-plus", "g_eq", "g_ne", "g_gt", "g_lt", "g_ge", "g_le", "is", "<<", ">>"};
    private FunctionOperatorHelper _functionOperatorHelper = null;
    private final Hashtable _functions = new Hashtable();
    private final PolymorphicFunctionDeclaration[] _operators = new PolymorphicFunctionDeclaration[23];
    protected Module _rtlibModule;
    public ModuleSignature s_moduleSignature;
    private ErrorHandler _errorHandler;
    private TypeFactory _typeFactory = null;
    private boolean _inGlobal = false;

    public XPathCompiler(String string, XSLTParser xSLTParser) {
        this._xpathVersion = string;
        this._parser = xSLTParser;
        this.initCompiler();
    }

    private void initCompiler() {
        this._parser.init();
        if (this._xpathVersion.equals("1.0")) {
            this._functionOperatorHelper = new FunctionOperatorHelper();
        } else {
            this.initFunctionAndOperatorDeclarations();
        }
        this._nextGType = 14;
        this._namesIndex = new ArrayList(128);
        this._elements = new Hashtable();
        this._attributes = new Hashtable();
        this._namespaceDecls = new Hashtable();
        this._namespaces = new Hashtable();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex = new ArrayList(32);
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
    }

    public void reset() {
        this._parser.reset();
        this._nextGType = 14;
        this._namesIndex.clear();
        this._elements.clear();
        this._attributes.clear();
        this._namespaceDecls.clear();
        this._namespaces.clear();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex.clear();
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
        this._typeFactory = null;
    }

    public int registerAttribute(QName qName) {
        Integer n = (Integer)this._attributes.get(qName.toString());
        if (n == null) {
            n = new Integer(this._nextGType++);
            this._attributes.put(qName.toString(), n);
            String string = qName.getNamespaceURI();
            String string2 = "@" + qName.getLocalPart();
            if (string != null && !string.equals("")) {
                this._namesIndex.add(string + ":" + string2);
            } else {
                this._namesIndex.add(string2);
            }
            if (qName.getLocalPart().equals("*")) {
                this.registerNamespace(qName.getNamespaceURI());
            }
        }
        return n;
    }

    public int registerElement(QName qName) {
        Integer n = (Integer)this._elements.get(qName.toString());
        if (n == null) {
            n = new Integer(this._nextGType++);
            this._elements.put(qName.toString(), n);
            String string = qName.getNamespaceURI();
            String string2 = qName.getLocalPart();
            if (string != null && !string.equals("")) {
                this._namesIndex.add(string + ":" + string2);
            } else {
                this._namesIndex.add(string2);
            }
        }
        if (qName.getLocalPart().equals("*")) {
            this.registerNamespace(qName.getNamespaceURI());
        }
        return n;
    }

    public int registerNamespaceDecl(QName qName) {
        Integer n = (Integer)this._namespaceDecls.get(qName.toString());
        if (n == null) {
            n = new Integer(this._nextGType++);
            this._namespaceDecls.put(qName.toString(), n);
            String string = qName.getNamespaceURI();
            String string2 = "%" + qName.getLocalPart();
            if (string != null && !string.equals("")) {
                this._namesIndex.add(string + ":" + string2);
            } else {
                this._namesIndex.add(string2);
            }
            if (qName.getLocalPart().equals("*")) {
                this.registerNamespace(qName.getNamespaceURI());
            }
        }
        return n;
    }

    public int registerNamespace(String string) {
        Integer n = (Integer)this._namespaces.get(string);
        if (n == null) {
            n = new Integer(this._nextNSType++);
            this._namespaces.put(string, n);
            this._namespaceIndex.add(string);
        }
        return n;
    }

    public List getNamesIndex() {
        return this._namesIndex;
    }

    public List getNamespaceIndex() {
        return this._namespaceIndex;
    }

    private void initFunctionAndOperatorDeclarations() {
        this.initSimpleFunctionDeclarations();
        this.initPolymorphicFunctionDeclarations();
        this.initOperatorDeclarations();
        this.initXtqhpFunctionDeclarations();
    }

    private void initSimpleFunctionDeclarations() {
        int n = this.funcTable.getSimpleFunctionLength();
        for (int i = 0; i < n; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 0);
            int n2 = this.funcTable.getSimpleFunctionDeclLength(i) - 3;
            String string = this.funcTable.getSimpleFunctionName(i) + String.valueOf(n2);
            this._functions.put(string, simpleFunctionDeclaration);
        }
    }

    private void initPolymorphicFunctionDeclarations() {
        int n = this.funcTable.getPolymorphicFunctionLength();
        for (int i = 0; i < n; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 1);
            String string = this.funcTable.getPolymorphicFunctionName(i);
            int n2 = this.funcTable.getPolymorphicFunctionDeclLength(i) - 4;
            String string2 = string + String.valueOf(n2);
            Object v = this._functions.get(string2);
            if (v == null) {
                PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = new PolymorphicFunctionDeclaration(string, n2, simpleFunctionDeclaration);
                this._functions.put(string2, polymorphicFunctionDeclaration);
                continue;
            }
            if (!(v instanceof PolymorphicFunctionDeclaration)) continue;
            ((PolymorphicFunctionDeclaration)v).addDeclarationEntry(simpleFunctionDeclaration);
        }
    }

    private void initXtqhpFunctionDeclarations() {
        int n = this.funcTable.getXtqhpFunctionLength();
        for (int i = 0; i < n; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 3);
            int n2 = this.funcTable.getXtqhpFunctionDeclLength(i) - 3;
            String string = this.funcTable.getXtqhpFunctionName(i) + String.valueOf(n2);
            this._functions.put(string, simpleFunctionDeclaration);
        }
    }

    private void initOperatorDeclaration(int n) {
        int n2 = this.funcTable.getOperatorItemLength(n);
        String string = this.OPERATOR_NAMES[n];
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.funcTable.getOperatorDeclLength(n, 0) - 4;
        }
        PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = new PolymorphicFunctionDeclaration(string, n3);
        for (int i = 0; i < n2; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, n, 2);
            polymorphicFunctionDeclaration.addDeclarationEntry(simpleFunctionDeclaration);
        }
        this._operators[n] = polymorphicFunctionDeclaration;
    }

    private void initOperatorDeclarations() {
        int n = this.funcTable.getOperatorLength();
        for (int i = 0; i < n; ++i) {
            this.initOperatorDeclaration(i);
        }
    }

    private SimpleFunctionDeclaration createFunctionDeclaration(int n, int n2, int n3) {
        String string;
        XSequenceType xSequenceType;
        int n4;
        XSequenceType[] xSequenceTypeArray;
        block7: {
            block9: {
                block8: {
                    block6: {
                        xSequenceTypeArray = null;
                        if (n3 != 1) break block6;
                        String string2 = this.funcTable.getPolymorphicFunctionName(n);
                        int n5 = this.funcTable.getPolymorphicFunctionDeclLength(n) - 4;
                        n4 = this.funcTable.getPolymorphicFunctionFlag(n);
                        xSequenceType = this.funcTable.getPolymorphicFunctionReturnType(n);
                        string = this.funcTable.getPolymorphicFunctionName_Real(n);
                        if (string == null) {
                            string = string2;
                        }
                        if (n5 <= 0) break block7;
                        xSequenceTypeArray = new XSequenceType[n5];
                        int n6 = 4;
                        for (int i = 0; i < n5; ++i) {
                            xSequenceTypeArray[i] = this.funcTable.getPolymorphicFunctionArgType(n, n6 + i);
                        }
                        break block7;
                    }
                    if (n3 != 2) break block8;
                    String string3 = this.funcTable.getOperatorName(n2, n);
                    int n7 = this.funcTable.getOperatorDeclLength(n2, n) - 4;
                    n4 = this.funcTable.getOperatorFlag(n2, n);
                    xSequenceType = this.funcTable.getOperatorReturnType(n2, n);
                    string = string3;
                    if (n7 <= 0) break block7;
                    xSequenceTypeArray = new XSequenceType[n7];
                    int n8 = 4;
                    for (int i = 0; i < n7; ++i) {
                        xSequenceTypeArray[i] = this.funcTable.getOperatorArgType(n2, n, n8 + i);
                    }
                    break block7;
                }
                if (n3 != 0) break block9;
                String string4 = this.funcTable.getSimpleFunctionName(n);
                int n9 = this.funcTable.getSimpleFunctionDeclLength(n) - 3;
                n4 = this.funcTable.getSimpleFunctionFlag(n);
                xSequenceType = this.funcTable.getSimpleFunctionReturnType(n);
                string = string4;
                if (n9 <= 0) break block7;
                xSequenceTypeArray = new XSequenceType[n9];
                int n10 = 3;
                for (int i = 0; i < n9; ++i) {
                    xSequenceTypeArray[i] = this.funcTable.getSimpleFunctionArgType(n, n10 + i);
                }
                break block7;
            }
            String string5 = this.funcTable.getXtqhpFunctionName(n);
            int n11 = this.funcTable.getXtqhpFunctionDeclLength(n) - 3;
            n4 = this.funcTable.getXtqhpFunctionFlag(n);
            xSequenceType = this.funcTable.getXtqhpFunctionReturnType(n);
            string = string5;
            if (n11 > 0) {
                xSequenceTypeArray = new XSequenceType[n11];
                int n12 = 3;
                for (int i = 0; i < n11; ++i) {
                    xSequenceTypeArray[i] = this.funcTable.getXtqhpFunctionArgType(n, n12 + i);
                }
            }
        }
        return new SimpleFunctionDeclaration(string, xSequenceType, xSequenceTypeArray, n4);
    }

    public Object getFunctionDeclarationFromSignature(String string, int n) {
        return this._functions.get(string + String.valueOf(n));
    }

    public PolymorphicFunctionDeclaration getOperatorDeclaration(int n) {
        return this._operators[n];
    }

    public String getXPathVersion() {
        return this._xpathVersion;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void setStaticTyping(boolean bl) {
        this._staticTyping = bl;
    }

    public boolean isStaticTyping() {
        return this._staticTyping;
    }

    public void setHasIdCall(boolean bl) {
        this._hasIdCall = bl;
    }

    public boolean hasIdCall() {
        return this._hasIdCall;
    }

    public void setCallsNodeset(boolean bl) {
        this._callsNodeset = bl;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void setInGlobal(boolean bl) {
        this._inGlobal = bl;
    }

    public boolean isInGlobal() {
        return this._inGlobal;
    }

    public int nextStepPatternSerial() {
        return this._stepPatternSerial++;
    }

    public Module getRuntimeLibrary() {
        return this._rtlibModule;
    }

    public void setRuntimeLibrary(Module module) {
        this._rtlibModule = module;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
        this._parser.setErrorHandler(errorHandler);
    }

    public SourceLocation createSourceLocation(Expr expr) {
        return null;
    }

    public void setSecureProcessing(boolean bl) {
        this._parser.setSecureProcessing(bl);
    }

    public FunctionOperatorHelper getFOHelper() {
        return this._functionOperatorHelper;
    }

    public TypeFactory getTypeFactory() {
        if (this._typeFactory == null) {
            this._typeFactory = new TypeFactory(this._parser.getStaticContext().getInScopeSchemaModel());
        }
        return this._typeFactory;
    }
}

