/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;

public final class URI {
    private String fScheme = "";
    private String fAuthority;
    private String fPath = "";
    private String fQuery;
    private String fFragment;
    private URI fBaseURI;
    private char[] fChars;
    private static final boolean WORKAROUND_JIT_BUG = true;
    private static final byte[] fgSchemeCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] fgURICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 2, 0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final byte[] fgHexCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public boolean parse(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.parseURI(string, true);
    }

    public boolean parse(URI uRI, String string) {
        if (uRI == null || string == null) {
            return false;
        }
        if (!this.parseURI(string, false)) {
            return false;
        }
        if (this.fScheme.length() == 0) {
            this.resolveRelativeTo(uRI);
        }
        return true;
    }

    private boolean parseURI(String string, boolean bl) {
        int n;
        int n2 = 47;
        int n3 = string.length();
        int n4 = n;
        this.fScheme = "";
        this.fAuthority = null;
        this.fPath = "";
        this.fQuery = null;
        this.fFragment = null;
        for (n = 0; n < n3; ++n) {
            n2 = string.charAt(n);
            if (n2 != 58) {
                if (n2 != 47 && n2 != 63 && n2 != 35) {
                    continue;
                }
                n = n4;
                n2 = string.charAt(n);
                break;
            }
            if (n <= n4) break;
            this.fScheme = string.substring(n4, n);
            if (this.parseScheme()) {
                if (++n < n3) {
                    n4 = n;
                    n2 = string.charAt(n);
                    break;
                }
                this.fPath = "";
                return URI.checkComponent(this.fPath, false, true);
            }
            return false;
        }
        if (bl && this.fScheme.length() == 0) {
            return false;
        }
        if (n + 1 < n3 && n2 == 47 && string.charAt(n + 1) == '/') {
            n4 = n += 2;
            while (n < n3) {
                n2 = string.charAt(n);
                if (n2 == 47 || n2 == 63 || n2 == 35) break;
                ++n;
            }
            this.fAuthority = string.substring(n4, n);
            if (!URI.checkComponent(this.fAuthority, true, true)) {
                return false;
            }
            n4 = n;
        }
        while (n < n3) {
            n2 = string.charAt(n);
            if (n2 == 63 || n2 == 35) break;
            ++n;
        }
        this.fPath = string.substring(n4, n);
        if (!URI.checkComponent(this.fPath, false, true)) {
            return false;
        }
        if (n2 == 63) {
            n4 = ++n;
            while (n < n3) {
                n2 = string.charAt(n);
                if (n2 == 35) break;
                ++n;
            }
            this.fQuery = string.substring(n4, n);
            if (!URI.checkComponent(this.fQuery, false, false)) {
                return false;
            }
        }
        if (n2 == 35) {
            n4 = ++n;
            while (n < n3) {
                n2 = string.charAt(n);
                if (n2 == 35) break;
                ++n;
            }
            this.fFragment = string.substring(n4, n);
            if (!URI.checkComponent(this.fFragment, false, false)) {
                return false;
            }
        }
        return true;
    }

    private void resolveRelativeTo(URI uRI) {
        int n;
        char c;
        int n2;
        int n3;
        int n4;
        block16: {
            int n5;
            this.fScheme = uRI.fScheme;
            if (this.fAuthority != null) {
                return;
            }
            if (uRI.fAuthority != null) {
                this.fAuthority = uRI.fAuthority;
            }
            if ((n5 = this.fPath.length()) == 0 && this.fQuery == null) {
                this.fPath = uRI.fPath;
                uRI.fQuery = null;
                if (this.fFragment == null && uRI.fFragment != null) {
                    this.fFragment = uRI.fFragment;
                }
                return;
            }
            if (n5 > 0 && this.fPath.charAt(0) == '/') {
                return;
            }
            String string = uRI.fPath;
            n4 = string.length() + n5;
            if (this.fChars == null || n4 > this.fChars.length) {
                int n6 = this.fChars != null ? this.fChars.length << 1 : 32;
                while (n4 > n6) {
                    n6 <<= 1;
                }
                this.fChars = new char[n6];
            }
            n4 = string.length();
            string.getChars(0, n4, this.fChars, 0);
            while (n4 > 0) {
                if (this.fChars[n4 - 1] == '/') break;
                --n4;
            }
            if (n4 == 0) {
                n4 = string.length();
            }
            this.fPath.getChars(0, n5, this.fChars, n4);
            n4 += n5;
            n3 = 0;
            n2 = 0;
            while (n3 < n4) {
                c = this.fChars[n3];
                if (c != '/' || ++n3 + 1 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '/') continue;
                n2 = n3;
                n3 += 2;
                while (n3 < n4) {
                    c = this.fChars[n3];
                    this.fChars[n2] = c;
                    ++n2;
                    if (c != '/' || ++n3 + 1 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '/') continue;
                    n3 += 2;
                }
                break block16;
            }
            n2 = n3;
        }
        if (n2 > 1 && this.fChars[n2 - 1] == '.' && this.fChars[n2 - 2] == '/') {
            --n2;
        }
        n4 = n2;
        n3 = 0;
        n2 = 0;
        while (n3 < n4) {
            c = this.fChars[n3];
            this.fChars[n2] = c;
            if (c != '/' || ++n2 == 1 || ++n3 + 2 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '.' || this.fChars[n3 + 2] != '/' || (n = n2 - 4) >= 0 && this.fChars[n] == '/' && this.fChars[n + 1] == '.' && this.fChars[n + 2] == '.') continue;
            n3 += 2;
            while (--n2 > 0 && this.fChars[n2 - 1] != '/') {
            }
            if (n2 <= 0 || this.fChars[n2 - 1] != '/') continue;
            --n2;
        }
        n4 = n2;
        n = n2 - 3;
        if (n >= 0 && this.fChars[n] == '/' && this.fChars[n + 1] == '.' && this.fChars[n + 2] == '.' && ((n -= 3) < 0 || this.fChars[n] != '/' || this.fChars[n + 1] != '.' || this.fChars[n + 2] != '.')) {
            n2 -= 3;
            while (n2 > 0 && this.fChars[n2 - 1] != '/') {
                --n2;
            }
        }
        n4 = n2;
        this.fPath = new String(this.fChars, 0, n4);
    }

    private boolean parseScheme() {
        String string = this.fScheme;
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        if (n == 0) {
            return false;
        }
        char c = string.charAt(n2);
        if (c >= '\u0080' || fgSchemeCharMap[c] != 1) {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            bl = true;
        }
        while (++n2 < n) {
            c = string.charAt(n2);
            if (c >= '\u0080' || fgSchemeCharMap[c] == 0) {
                return false;
            }
            if (c < 'A' || c > 'Z') continue;
            bl = true;
        }
        if (bl) {
            this.fScheme = string.toLowerCase(Locale.ENGLISH);
        }
        return true;
    }

    private static boolean checkComponent(String string, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                return false;
            }
            switch (fgURICharMap[c]) {
                case 1: {
                    break;
                }
                case 2: {
                    if ((!bl || c != '/') && (!bl2 || c != '?')) break;
                    return false;
                }
                case 3: {
                    if (n2 + 2 >= n) {
                        return false;
                    }
                    if ((c = string.charAt(++n2)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return false;
                    }
                    if ((c = string.charAt(++n2)) < '\u0080' && fgHexCharMap[c] != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fScheme.length() > 0) {
            stringBuffer.append(this.fScheme);
            stringBuffer.append(':');
        }
        if (this.fAuthority != null) {
            stringBuffer.append('/');
            stringBuffer.append('/');
            stringBuffer.append(this.fAuthority);
        }
        stringBuffer.append(this.fPath);
        if (this.fQuery != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.fQuery);
        }
        if (this.fFragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fFragment);
        }
        return stringBuffer.toString();
    }

    public String expand(String string, String string2) {
        if (!this.parse(string)) {
            URI uRI = this.fBaseURI;
            if (uRI == null) {
                uRI = this.fBaseURI = new URI();
            }
            if (uRI.parse(string2) && this.parse(uRI, string)) {
                return this.toString();
            }
        }
        return string;
    }

    public static InputStream openStream(String string) throws IOException {
        return new URL(string).openStream();
    }
}

