/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShuffleExceptionTracker {
    public static final Log LOG = LogFactory.getLog(ShuffleExceptionTracker.class);
    private BitSet requests;
    private final int size;
    private int index;
    private final String exceptionStackRegex;
    private final String exceptionMsgRegex;
    private final float shuffleExceptionLimit;

    ShuffleExceptionTracker(int numberRequests, String exceptionStackRegex, String exceptionMsgRegex, float shuffleExceptionLimit) {
        this.exceptionStackRegex = exceptionStackRegex;
        this.exceptionMsgRegex = exceptionMsgRegex;
        this.shuffleExceptionLimit = shuffleExceptionLimit;
        this.size = numberRequests;
        this.index = 0;
        this.requests = new BitSet(this.size);
    }

    public int getNumRequests() {
        return this.size;
    }

    public synchronized float getPercentExceptions() {
        return (float)this.requests.cardinality() / (float)this.size;
    }

    public synchronized void success() {
        if (this.shuffleExceptionLimit > 0.0f) {
            this.requests.clear(this.index);
            this.incrIndex();
        }
    }

    public synchronized void exception() {
        if (this.shuffleExceptionLimit > 0.0f) {
            this.requests.set(this.index);
            this.incrIndex();
        }
    }

    public boolean checkException(IOException ie) {
        String msg;
        if (!(this.exceptionMsgRegex == null || (msg = ie.getMessage()) != null && msg.matches(this.exceptionMsgRegex))) {
            this.success();
            return false;
        }
        if (this.exceptionStackRegex != null && !this.checkStackException(ie)) {
            this.success();
            return false;
        }
        this.exception();
        if (this.shuffleExceptionLimit > 0.0f && this.getPercentExceptions() >= this.shuffleExceptionLimit) {
            LOG.fatal("************************************************************\nShuffle exception count is greater than the fatal limit: " + this.shuffleExceptionLimit + "Aborting JVM.\n" + "************************************************************");
            this.doAbort();
        }
        return true;
    }

    private boolean checkStackException(IOException ie) {
        StackTraceElement[] stack;
        for (StackTraceElement elem : stack = ie.getStackTrace()) {
            String stacktrace = elem.toString();
            if (!stacktrace.matches(this.exceptionStackRegex)) continue;
            return true;
        }
        return false;
    }

    protected void doAbort() {
        System.exit(1);
    }

    private void incrIndex() {
        this.index = this.index == this.size - 1 ? 0 : ++this.index;
    }
}

