/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.model.WorkflowModel;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowInputResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowOutputResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogThriftConversion;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogUtils;
import org.apache.airavata.registry.cpi.WorkflowCatalog;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCatalogImpl
implements WorkflowCatalog {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowCatalogImpl.class);

    public List<String> getAllWorkflows(String gatewayId) throws WorkflowCatalogException {
        ArrayList<String> workflowIds = new ArrayList();
        try {
            WorkflowResource resource = new WorkflowResource();
            resource.setGatewayId(gatewayId);
            workflowIds = resource.getAllIds();
        }
        catch (Exception e) {
            logger.error("Error while retrieving all the workflow template ids...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        return workflowIds;
    }

    public WorkflowModel getWorkflow(String workflowTemplateId) throws WorkflowCatalogException {
        try {
            WorkflowResource resource = new WorkflowResource();
            WorkflowResource wfResource = (WorkflowResource)resource.get(workflowTemplateId);
            return WorkflowCatalogThriftConversion.getWorkflow(wfResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving the workflow...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
    }

    public void deleteWorkflow(String workflowTemplateId) throws WorkflowCatalogException {
        try {
            WorkflowResource resource = new WorkflowResource();
            resource.remove(workflowTemplateId);
        }
        catch (Exception e) {
            logger.error("Error while deleting the workflow...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
    }

    public String registerWorkflow(WorkflowModel workflow, String gatewayId) throws WorkflowCatalogException {
        try {
            List workflowOutputs;
            WorkflowResource resource = new WorkflowResource();
            resource.setWfTemplateId(WorkflowCatalogUtils.getID(workflow.getName()));
            resource.setWfName(workflow.getName());
            resource.setGraph(workflow.getGraph());
            resource.setGatewayId(gatewayId);
            if (workflow.getImage() != null) {
                resource.setImage(new String(workflow.getImage()));
            }
            resource.save();
            workflow.setTemplateId(resource.getWfTemplateId());
            List workflowInputs = workflow.getWorkflowInputs();
            if (workflowInputs != null && workflowInputs.size() != 0) {
                for (InputDataObjectType input : workflowInputs) {
                    WorkflowInputResource wfInputResource = new WorkflowInputResource();
                    wfInputResource.setWorkflowResource(resource);
                    wfInputResource.setInputKey(input.getName());
                    wfInputResource.setInputVal(input.getValue());
                    wfInputResource.setWfTemplateId(resource.getWfTemplateId());
                    wfInputResource.setDataType(input.getType().toString());
                    wfInputResource.setAppArgument(input.getApplicationArgument());
                    wfInputResource.setStandardInput(input.isStandardInput());
                    wfInputResource.setUserFriendlyDesc(input.getUserFriendlyDescription());
                    wfInputResource.setMetadata(input.getMetaData());
                    wfInputResource.save();
                }
            }
            if ((workflowOutputs = workflow.getWorkflowOutputs()) != null && workflowOutputs.size() != 0) {
                for (OutputDataObjectType output : workflowOutputs) {
                    WorkflowOutputResource outputResource = new WorkflowOutputResource();
                    outputResource.setWorkflowResource(resource);
                    outputResource.setOutputKey(output.getName());
                    outputResource.setOutputVal(output.getValue());
                    outputResource.setWfTemplateId(resource.getWfTemplateId());
                    outputResource.setDataType(output.getType().toString());
                    outputResource.setAppArgument(output.getApplicationArgument());
                    outputResource.setDataNameLocation(output.getLocation());
                    outputResource.setRequired(output.isIsRequired());
                    outputResource.setRequiredToCMD(output.isRequiredToAddedToCommandLine());
                    outputResource.setOutputStreaming(output.isOutputStreaming());
                    outputResource.setDataMovement(output.isDataMovement());
                    outputResource.save();
                }
            }
            return resource.getWfTemplateId();
        }
        catch (Exception e) {
            logger.error("Error while saving the workflow...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
    }

    public void updateWorkflow(String workflowTemplateId, WorkflowModel workflow) throws WorkflowCatalogException {
        try {
            List workflowOutputs;
            WorkflowResource resource = new WorkflowResource();
            WorkflowResource existingWF = (WorkflowResource)resource.get(workflowTemplateId);
            existingWF.setWfName(workflow.getName());
            existingWF.setGraph(workflow.getGraph());
            if (workflow.getImage() != null) {
                existingWF.setImage(new String(workflow.getImage()));
            }
            existingWF.save();
            List existingwFInputs = workflow.getWorkflowInputs();
            if (existingwFInputs != null && existingwFInputs.size() != 0) {
                for (InputDataObjectType input : existingwFInputs) {
                    WorkflowInputResource wfInputResource = new WorkflowInputResource();
                    HashMap<String, String> ids = new HashMap<String, String>();
                    ids.put("templateID", existingWF.getWfTemplateId());
                    ids.put("inputKey", input.getName());
                    WorkflowInputResource existingInput = (WorkflowInputResource)wfInputResource.get(ids);
                    existingInput.setWorkflowResource(existingWF);
                    existingInput.setInputKey(input.getName());
                    existingInput.setInputVal(input.getValue());
                    existingInput.setWfTemplateId(existingWF.getWfTemplateId());
                    existingInput.setDataType(input.getType().toString());
                    existingInput.setAppArgument(input.getApplicationArgument());
                    existingInput.setStandardInput(input.isStandardInput());
                    existingInput.setUserFriendlyDesc(input.getUserFriendlyDescription());
                    existingInput.setMetadata(input.getMetaData());
                    existingInput.save();
                }
            }
            if ((workflowOutputs = workflow.getWorkflowOutputs()) != null && workflowOutputs.size() != 0) {
                for (OutputDataObjectType output : workflowOutputs) {
                    WorkflowOutputResource outputResource = new WorkflowOutputResource();
                    HashMap<String, String> ids = new HashMap<String, String>();
                    ids.put("templateId", existingWF.getWfTemplateId());
                    ids.put("outputKey", output.getName());
                    WorkflowOutputResource existingOutput = (WorkflowOutputResource)outputResource.get(ids);
                    existingOutput.setWorkflowResource(existingWF);
                    existingOutput.setOutputKey(output.getName());
                    existingOutput.setOutputVal(output.getValue());
                    existingOutput.setWfTemplateId(existingWF.getWfTemplateId());
                    existingOutput.setDataType(output.getType().toString());
                    existingOutput.setDataType(output.getType().toString());
                    existingOutput.setAppArgument(output.getApplicationArgument());
                    existingOutput.setDataNameLocation(output.getLocation());
                    existingOutput.setRequired(output.isIsRequired());
                    existingOutput.setRequiredToCMD(output.isRequiredToAddedToCommandLine());
                    existingOutput.setOutputStreaming(output.isOutputStreaming());
                    existingOutput.setDataMovement(output.isDataMovement());
                    existingOutput.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating the workflow...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
    }

    public String getWorkflowTemplateId(String workflowName) throws WorkflowCatalogException {
        try {
            WorkflowResource resource = new WorkflowResource();
            List<WorkflowCatalogResource> resourceList = resource.get("workflowName", workflowName);
            if (resourceList != null && !resourceList.isEmpty()) {
                WorkflowResource wfResource = (WorkflowResource)resourceList.get(0);
                return wfResource.getWfTemplateId();
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving the workflow with the workflow name...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        return null;
    }

    public boolean isWorkflowExistWithName(String workflowName) throws WorkflowCatalogException {
        try {
            WorkflowResource resource = new WorkflowResource();
            List<WorkflowCatalogResource> resourceList = resource.get("workflowName", workflowName);
            if (resourceList != null && !resourceList.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving the workflow with the workflow name...", (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        return false;
    }

    public void updateWorkflowOutputs(String workflowTemplateId, List<OutputDataObjectType> workflowOutputs) throws WorkflowCatalogException {
        WorkflowResource resource = new WorkflowResource();
        WorkflowResource existingWF = (WorkflowResource)resource.get(workflowTemplateId);
        if (workflowOutputs != null && workflowOutputs.size() != 0) {
            for (OutputDataObjectType output : workflowOutputs) {
                WorkflowOutputResource outputResource = new WorkflowOutputResource();
                HashMap<String, String> ids = new HashMap<String, String>();
                ids.put("templateId", existingWF.getWfTemplateId());
                ids.put("outputKey", output.getName());
                WorkflowOutputResource existingOutput = (WorkflowOutputResource)outputResource.get(ids);
                existingOutput.setWorkflowResource(existingWF);
                existingOutput.setOutputKey(output.getName());
                existingOutput.setOutputVal(output.getValue());
                existingOutput.setWfTemplateId(existingWF.getWfTemplateId());
                existingOutput.setDataType(output.getType().toString());
                existingOutput.setDataType(output.getType().toString());
                existingOutput.setAppArgument(output.getApplicationArgument());
                existingOutput.setDataNameLocation(output.getLocation());
                existingOutput.setRequired(output.isIsRequired());
                existingOutput.setRequiredToCMD(output.isRequiredToAddedToCommandLine());
                existingOutput.setOutputStreaming(output.isOutputStreaming());
                existingOutput.setDataMovement(output.isDataMovement());
                existingOutput.save();
            }
        }
    }
}

