/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentSummary;
import org.apache.airavata.registry.core.experiment.catalog.model.Gateway;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorker;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorkerPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Project;
import org.apache.airavata.registry.core.experiment.catalog.model.UserPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Users;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentStatisticsResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentSummaryResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkerResource.class);
    private String user;
    private String gatewayId;

    public WorkerResource() {
    }

    public WorkerResource(String user, String gatewayId) {
        this.user = user;
        this.gatewayId = gatewayId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        AbstractExpCatResource result = null;
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setWorker(this);
                projectResource.setGatewayId(this.gatewayId);
                result = projectResource;
                break;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setUserName(this.user);
                experimentResource.setGatewayExecutionId(this.gatewayId);
                result = experimentResource;
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for worker resource.");
            }
        }
        return result;
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    generator.setParameter("projectId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("experimentId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        ExperimentCatResource result = null;
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    generator.setParameter("projectId", name);
                    Query q = generator.selectQuery(em);
                    Project project = (Project)q.getSingleResult();
                    result = Utils.getResource(ResourceType.PROJECT, project);
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("experimentId", name);
                    Query q = generator.selectQuery(em);
                    Experiment experiment = (Experiment)q.getSingleResult();
                    result = Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        return this.get(type, -1, -1, null, null);
    }

    public List<ExperimentCatResource> get(ResourceType type, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ExperimentCatResource> result = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    UserPK userPK = new UserPK();
                    userPK.setGatewayId(this.getGatewayId());
                    userPK.setUserName(this.user);
                    Users users = (Users)em.find(Users.class, (Object)userPK);
                    Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gatewayId);
                    generator.setParameter("users", users);
                    if (gatewayModel != null) {
                        generator.setParameter("gateway", gatewayModel);
                    }
                    Query q = orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime") ? generator.selectQuery(em, "creationTime", resultOrderType) : generator.selectQuery(em);
                    if (limit > 0 && offset >= 0) {
                        q.setFirstResult(offset);
                        q.setMaxResults(limit);
                    }
                    for (Object o : q.getResultList()) {
                        Project project = (Project)o;
                        ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                        result.add(projectResource);
                    }
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("userName", this.getUser());
                    Query q = orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime") ? generator.selectQuery(em, "creationTime", resultOrderType) : generator.selectQuery(em);
                    if (limit > 0 && offset >= 0) {
                        q.setFirstResult(offset);
                        q.setMaxResults(limit);
                    }
                    for (Object o : q.getResultList()) {
                        Experiment experiment = (Experiment)o;
                        ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                        result.add(experimentResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            GatewayWorkerPK gatewayWorkerPK = new GatewayWorkerPK();
            gatewayWorkerPK.setGatewayId(this.gatewayId);
            gatewayWorkerPK.setUserName(this.user);
            GatewayWorker existingWorker = (GatewayWorker)em.find(GatewayWorker.class, (Object)gatewayWorkerPK);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            GatewayWorker gatewayWorker = new GatewayWorker();
            gatewayWorker.setUserName(this.user);
            gatewayWorker.setGatewayId(this.gatewayId);
            if (existingWorker != null) {
                existingWorker.setUserName(this.user);
                existingWorker.setGatewayId(this.gatewayId);
                gatewayWorker = (GatewayWorker)em.merge((Object)existingWorker);
            } else {
                em.persist((Object)gatewayWorker);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isProjectExists(String id) throws RegistryException {
        return this.isExists(ResourceType.PROJECT, id);
    }

    public ProjectResource createProject(String projectId) throws RegistryException {
        ProjectResource project = (ProjectResource)this.create(ResourceType.PROJECT);
        project.setId(projectId);
        return project;
    }

    public ProjectResource getProject(String id) throws RegistryException {
        return (ProjectResource)this.get(ResourceType.PROJECT, id);
    }

    public void removeProject(String id) throws RegistryException {
        this.remove(ResourceType.PROJECT, id);
    }

    public List<ProjectResource> getProjects() throws RegistryException {
        return this.getProjects(-1, -1, null, null);
    }

    public List<ProjectResource> getProjects(int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ProjectResource> result = new ArrayList<ProjectResource>();
        List<ExperimentCatResource> list = this.get(ResourceType.PROJECT, limit, offset, orderByIdentifier, resultOrderType);
        for (ExperimentCatResource resource : list) {
            result.add((ProjectResource)resource);
        }
        return result;
    }

    public boolean isExperimentExists(String name) throws RegistryException {
        return this.isExists(ResourceType.EXPERIMENT, name);
    }

    public ExperimentResource getExperiment(String name) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, name);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        return this.getExperiments(-1, -1, null, null);
    }

    public List<ExperimentResource> getExperiments(int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        List<ExperimentCatResource> list = this.get(ResourceType.EXPERIMENT, limit, offset, orderByIdentifier, resultOrderType);
        for (ExperimentCatResource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ProjectResource> searchProjects(Map<String, String> filters, List<String> accessibleIds, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ProjectResource> result = new ArrayList<ProjectResource>();
        EntityManager em = null;
        try {
            HashMap<String, String> queryParameters = new HashMap<String, String>();
            String query = "SELECT DISTINCT p from Project p WHERE ";
            if (accessibleIds != null && accessibleIds.size() > 0) {
                query = query + " p.projectId IN (";
                int accessibleIdIndex = 0;
                for (String id : accessibleIds) {
                    String paramName = "accessibleId" + accessibleIdIndex;
                    query = query + ":" + paramName + ",";
                    queryParameters.put(paramName, id);
                    ++accessibleIdIndex;
                }
                query = query.substring(0, query.length() - 1) + ") AND ";
            } else if (ServerSettings.isEnableSharing().booleanValue() && (accessibleIds == null || accessibleIds.size() == 0)) {
                ArrayList<ProjectResource> accessibleIdIndex = new ArrayList<ProjectResource>();
                return accessibleIdIndex;
            }
            if (filters != null && filters.size() != 0) {
                for (String string : filters.keySet()) {
                    String filterVal = filters.get(string);
                    if (string.equals("userName")) {
                        query = query + "p." + string + "= :" + string + " AND ";
                        queryParameters.put(string, filterVal);
                        continue;
                    }
                    if (string.equals("gatewayId")) {
                        query = query + "p." + string + "= :" + string + " AND ";
                        queryParameters.put(string, filterVal);
                        continue;
                    }
                    if (filterVal.contains("*")) {
                        filterVal = filterVal.replaceAll("\\*", "");
                    }
                    query = query + "p." + string + " LIKE :" + string + " AND ";
                    queryParameters.put(string, "%" + filterVal + "%");
                }
            }
            query = query.substring(0, query.length() - 5);
            if (orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime")) {
                String order = resultOrderType == ResultOrderType.ASC ? "ASC" : "DESC";
                query = query + " ORDER BY p.creationTime " + order;
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = offset >= 0 && limit >= 0 ? em.createQuery(query).setFirstResult(offset).setMaxResults(limit) : em.createQuery(query);
            for (String parameterName : queryParameters.keySet()) {
                q.setParameter(parameterName, queryParameters.get(parameterName));
            }
            List list = q.getResultList();
            for (Object o : list) {
                Project project = (Project)o;
                ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                result.add(projectResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    public List<ExperimentSummaryResource> searchExperiments(List<String> accessibleIds, Timestamp fromTime, Timestamp toTime, Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ExperimentSummaryResource> result = new ArrayList<ExperimentSummaryResource>();
        EntityManager em = null;
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            String query = "SELECT e FROM ExperimentSummary e WHERE ";
            if (accessibleIds != null && accessibleIds.size() > 0) {
                query = query + " e.experimentId IN (";
                int accessibleIdIndex = 0;
                for (String id : accessibleIds) {
                    String paramName = "accessibleId" + accessibleIdIndex;
                    query = query + ":" + paramName + ",";
                    queryParameters.put(paramName, id);
                    ++accessibleIdIndex;
                }
                query = query.substring(0, query.length() - 1) + ") AND ";
            } else if (ServerSettings.isEnableSharing().booleanValue() && (accessibleIds == null || accessibleIds.size() == 0)) {
                ArrayList<ExperimentSummaryResource> accessibleIdIndex = new ArrayList<ExperimentSummaryResource>();
                return accessibleIdIndex;
            }
            if (filters.get("state") != null) {
                String experimentState = ExperimentState.valueOf((String)filters.get("state")).toString();
                query = query + "e.state='" + experimentState + "' AND ";
            }
            if (toTime != null && fromTime != null && toTime.after(fromTime)) {
                query = query + "e.creationTime > :fromTime AND e.creationTime < :toTime AND ";
                queryParameters.put("fromTime", fromTime);
                queryParameters.put("toTime", toTime);
            }
            filters.remove("state");
            if (filters != null && filters.size() != 0) {
                for (String string : filters.keySet()) {
                    String filterVal = filters.get(string);
                    if (string.equals("userName")) {
                        query = query + "e." + string + "= :username AND ";
                        queryParameters.put("username", filterVal);
                        continue;
                    }
                    if (string.equals("gatewayId")) {
                        query = query + "e." + string + "= :gateway_id AND ";
                        queryParameters.put("gateway_id", filterVal);
                        continue;
                    }
                    if (string.equals("projectId")) {
                        query = query + "e." + string + "= :project_id AND ";
                        queryParameters.put("project_id", filterVal);
                        continue;
                    }
                    if (filterVal.contains("*")) {
                        filterVal = filterVal.replaceAll("\\*", "");
                    }
                    query = query + "e." + string + " LIKE :" + string + " AND ";
                    queryParameters.put(string, "%" + filterVal + "%");
                }
            }
            query = query.substring(0, query.length() - 5);
            if (orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime")) {
                String order = resultOrderType == ResultOrderType.ASC ? "ASC" : "DESC";
                query = query + " ORDER BY e.creationTime " + order;
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = offset >= 0 && limit >= 0 ? em.createQuery(query).setFirstResult(offset).setMaxResults(limit) : em.createQuery(query);
            for (String parameterName : queryParameters.keySet()) {
                q.setParameter(parameterName, queryParameters.get(parameterName));
            }
            List list = q.getResultList();
            for (Object o : list) {
                ExperimentSummary experimentSummary = (ExperimentSummary)o;
                ExperimentSummaryResource experimentSummaryResource = (ExperimentSummaryResource)Utils.getResource(ResourceType.EXPERIMENT_SUMMARY, experimentSummary);
                result.add(experimentSummaryResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    public ExperimentStatisticsResource getExperimentStatistics(String gatewayId, Timestamp fromTime, Timestamp toTime, String userName, String applicationName, String resourceHostName) throws RegistryException {
        ExperimentStatisticsResource experimentStatisticsResource = new ExperimentStatisticsResource();
        List<ExperimentSummaryResource> allExperiments = this.getExperimentStatisticsForState(null, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        experimentStatisticsResource.setAllExperimentCount(allExperiments.size());
        experimentStatisticsResource.setAllExperiments(allExperiments);
        List<ExperimentSummaryResource> createdExperiments = this.getExperimentStatisticsForState(ExperimentState.CREATED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        createdExperiments.addAll(this.getExperimentStatisticsForState(ExperimentState.VALIDATED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName));
        experimentStatisticsResource.setCreatedExperimentCount(createdExperiments.size());
        experimentStatisticsResource.setCreatedExperiments(createdExperiments);
        List<ExperimentSummaryResource> runningExperiments = this.getExperimentStatisticsForState(ExperimentState.EXECUTING, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        runningExperiments.addAll(this.getExperimentStatisticsForState(ExperimentState.SCHEDULED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName));
        runningExperiments.addAll(this.getExperimentStatisticsForState(ExperimentState.LAUNCHED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName));
        experimentStatisticsResource.setRunningExperimentCount(runningExperiments.size());
        experimentStatisticsResource.setRunningExperiments(runningExperiments);
        List<ExperimentSummaryResource> completedExperiments = this.getExperimentStatisticsForState(ExperimentState.COMPLETED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        experimentStatisticsResource.setCompletedExperimentCount(completedExperiments.size());
        experimentStatisticsResource.setCompletedExperiments(completedExperiments);
        List<ExperimentSummaryResource> failedExperiments = this.getExperimentStatisticsForState(ExperimentState.FAILED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        experimentStatisticsResource.setFailedExperimentCount(failedExperiments.size());
        experimentStatisticsResource.setFailedExperiments(failedExperiments);
        List<ExperimentSummaryResource> cancelledExperiments = this.getExperimentStatisticsForState(ExperimentState.CANCELED, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
        cancelledExperiments.addAll(this.getExperimentStatisticsForState(ExperimentState.CANCELING, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName));
        experimentStatisticsResource.setCancelledExperimentCount(cancelledExperiments.size());
        experimentStatisticsResource.setCancelledExperiments(cancelledExperiments);
        return experimentStatisticsResource;
    }

    private List<ExperimentSummaryResource> getExperimentStatisticsForState(ExperimentState expState, String gatewayId, Timestamp fromTime, Timestamp toTime, String userName, String applicationName, String resourceHostName) throws RegistryException {
        EntityManager em = null;
        ArrayList<ExperimentSummaryResource> result = new ArrayList<ExperimentSummaryResource>();
        try {
            HashMap<String, String> queryParameters = new HashMap<String, String>();
            String query = "SELECT e FROM ExperimentSummary e WHERE ";
            if (expState != null) {
                query = query + "e.state='" + expState.toString() + "' AND ";
            }
            query = query + "e.creationTime > '" + fromTime + "' AND e.creationTime <'" + toTime + "' AND ";
            query = query + "e.gatewayId= '" + gatewayId + "' ";
            if (userName != null) {
                query = query + "AND e.userName LIKE :userName ";
                queryParameters.put("userName", "%" + userName + "%");
            }
            if (applicationName != null) {
                query = query + "AND e.executionId LIKE :applicationName ";
                queryParameters.put("applicationName", "%" + applicationName + "%");
            }
            if (resourceHostName != null) {
                query = query + "AND e.resourceHostId LIKE :resourceHostName ";
                queryParameters.put("resourceHostName", "%" + resourceHostName + "%");
            }
            query = query + "ORDER BY e.creationTime DESC";
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = em.createQuery(query);
            for (String parameterName : queryParameters.keySet()) {
                q.setParameter(parameterName, queryParameters.get(parameterName));
            }
            List resultList = q.getResultList();
            for (Object o : resultList) {
                ExperimentSummary experimentSummary = (ExperimentSummary)o;
                ExperimentSummaryResource experimentSummaryResource = (ExperimentSummaryResource)Utils.getResource(ResourceType.EXPERIMENT_SUMMARY, experimentSummary);
                result.add(experimentSummaryResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }
}

