/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.UFTPSessionClient;
import eu.unicore.uftp.dpc.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;

public class SessionCommands {
    public static Runnable createCMD(List<String> args, UFTPSessionClient client) {
        String name = args.remove(0);
        CmdBase cmd = null;
        if ("get".equalsIgnoreCase(name)) {
            cmd = new Get(args);
        }
        if ("put".equalsIgnoreCase(name)) {
            cmd = new Put(args);
        }
        if ("lcd".equalsIgnoreCase(name)) {
            cmd = new LCD(args);
        }
        if (cmd != null) {
            cmd.setClient(client);
        }
        return cmd;
    }

    public static class LCD
    extends CmdBase {
        String base;

        public LCD(List<String> args) {
            this.base = Utils.trim(args.get(0));
        }

        @Override
        public void run() {
            this.client.setBaseDirectory(new File(this.base));
        }
    }

    public static class Put
    extends CmdBase {
        private String remoteName;
        String localFilename;
        long size = -1L;

        public Put(List<String> args) {
            this.localFilename = Utils.trim(args.get(0));
            this.remoteName = args.size() > 1 ? args.get(1) : new File(this.localFilename).getName();
            if (args.size() > 2) {
                this.size = Long.valueOf(args.get(2));
            }
        }

        @Override
        public void run() {
            FileInputStream localSource = null;
            File localFile = new File(this.client.getBaseDirectory(), this.localFilename);
            if (this.size < 0L) {
                this.size = localFile.length();
            }
            try {
                localSource = new FileInputStream(localFile);
                this.client.put(this.remoteName, this.size, localSource);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (localSource != null) {
                    try {
                        localSource.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    public static class Get
    extends CmdBase {
        private File remoteFile;
        String localName;

        public Get(List<String> args) {
            this.remoteFile = new File(Utils.trim(args.get(0)));
            this.localName = args.size() > 1 ? args.get(1) : this.remoteFile.getName();
        }

        @Override
        public void run() {
            FileOutputStream localTarget = null;
            try {
                localTarget = new FileOutputStream(new File(this.client.getBaseDirectory(), this.localName));
                this.client.get(this.remoteFile.getPath(), localTarget);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (localTarget != null) {
                    try {
                        localTarget.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    public static abstract class CmdBase
    implements Runnable {
        protected UFTPSessionClient client;

        public void setClient(UFTPSessionClient client) {
            this.client = client;
        }
    }
}

