/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.assertion;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.assertion.AssertionParser;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.AuthnContextType;
import xmlbeans.org.oasis.saml2.assertion.AuthnStatementType;
import xmlbeans.org.oasis.saml2.assertion.ConditionAbstractType;
import xmlbeans.org.oasis.saml2.assertion.ConditionsType;
import xmlbeans.org.oasis.saml2.assertion.KeyInfoConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;

public class Assertion
extends AssertionParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String ID_PREFIX = "SAMLY2lib_assert_";

    public Assertion() {
        this.assertionDoc = AssertionDocument.Factory.newInstance();
        AssertionType assertion = this.assertionDoc.addNewAssertion();
        assertion.setVersion("2.0");
        assertion.setIssueInstant(Calendar.getInstance());
        assertion.setID(SAMLUtils.genID(ID_PREFIX));
    }

    public Assertion(AssertionDocument doc) {
        super(doc);
    }

    public void setX509Issuer(String issuerName) {
        String dn = X500NameUtils.getPortableRFC2253Form((String)issuerName);
        NameIDType issuerN = NameIDType.Factory.newInstance();
        issuerN.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        issuerN.setStringValue(dn);
        this.assertionDoc.getAssertion().setIssuer(issuerN);
    }

    public void setIssuer(String value, String format) {
        NameIDType issuer = NameIDType.Factory.newInstance();
        issuer.setStringValue(value);
        issuer.setFormat(format);
        this.assertionDoc.getAssertion().setIssuer(issuer);
    }

    public void setX509Subject(String subjectName) {
        String dn = X500NameUtils.getPortableRFC2253Form((String)subjectName);
        NameIDType subjectN = NameIDType.Factory.newInstance();
        subjectN.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        subjectN.setStringValue(dn);
        SubjectType subjectT = SubjectType.Factory.newInstance();
        subjectT.setNameID(subjectN);
        this.assertionDoc.getAssertion().setSubject(subjectT);
    }

    public void setSubject(NameIDType subject) {
        SubjectType subjectT = SubjectType.Factory.newInstance();
        subjectT.setNameID(subject);
        this.assertionDoc.getAssertion().setSubject(subjectT);
    }

    public void setSubject(SubjectType subject) {
        if (this.assertionDoc.getAssertion().isSetSubject()) {
            this.assertionDoc.getAssertion().unsetSubject();
        }
        SubjectType added = this.assertionDoc.getAssertion().addNewSubject();
        if (subject.isSetNameID()) {
            added.setNameID(subject.getNameID());
        }
        if (subject.isSetEncryptedID()) {
            added.setEncryptedID(subject.getEncryptedID());
        }
        if (subject.isSetBaseID()) {
            added.setBaseID(subject.getBaseID());
        }
        if (subject.sizeOfSubjectConfirmationArray() > 0) {
            added.setSubjectConfirmationArray(subject.getSubjectConfirmationArray());
        }
    }

    public void setHolderOfKeyConfirmation(X509Certificate[] certificates) throws CertificateEncodingException {
        this.setConfirmation(certificates, "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
    }

    public void setSenderVouchesX509Confirmation(X509Certificate[] certificates) throws CertificateEncodingException {
        this.setConfirmation(certificates, "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
    }

    private void setConfirmation(X509Certificate[] certificates, String method) throws CertificateEncodingException {
        SubjectType subject = this.assertionDoc.getAssertion().getSubject();
        SubjectConfirmationType confirmation = subject.addNewSubjectConfirmation();
        confirmation.setMethod(method);
        KeyInfoConfirmationDataType confirData = KeyInfoConfirmationDataType.Factory.newInstance();
        KeyInfoType ki = DigSignatureUtil.generateX509KeyInfo(certificates);
        confirData.setKeyInfoArray(new KeyInfoType[]{ki});
        confirmation.setSubjectConfirmationData(confirData);
    }

    public void updateIssueTime() {
        this.assertionDoc.getAssertion().setIssueInstant(Calendar.getInstance());
    }

    protected ConditionsType getOrCreateConditions() {
        ConditionsType conditions = this.assertionDoc.getAssertion().getConditions();
        if (conditions == null) {
            return this.assertionDoc.getAssertion().addNewConditions();
        }
        return conditions;
    }

    public void setTimeConditions(Date notBefore, Date notOnOrAfter) {
        Calendar c = Calendar.getInstance();
        ConditionsType conditions = this.getOrCreateConditions();
        if (notBefore != null) {
            c.setTime(notBefore);
            conditions.setNotBefore(c);
        } else if (conditions.isSetNotBefore()) {
            conditions.unsetNotBefore();
        }
        if (notOnOrAfter != null) {
            c.setTime(notOnOrAfter);
            conditions.setNotOnOrAfter(c);
        } else if (conditions.isSetNotOnOrAfter()) {
            conditions.unsetNotOnOrAfter();
        }
    }

    public void setProxyRestriction(int value) {
        ConditionsType conditions = this.getOrCreateConditions();
        if (value > 0) {
            if (conditions.sizeOfProxyRestrictionArray() == 0) {
                conditions.addNewProxyRestriction();
            }
            conditions.getProxyRestrictionArray(0).setCount(BigInteger.valueOf(value));
        } else if (conditions.sizeOfProxyRestrictionArray() > 0) {
            conditions.removeProxyRestriction(0);
        }
    }

    public void setAudienceRestriction(String[] audienceArray) {
        ConditionsType conditions = this.getOrCreateConditions();
        if (audienceArray != null) {
            if (conditions.sizeOfAudienceRestrictionArray() == 0) {
                conditions.addNewAudienceRestriction();
            }
            conditions.getAudienceRestrictionArray(0).setAudienceArray(audienceArray);
        } else if (conditions.sizeOfAudienceRestrictionArray() != 0) {
            conditions.removeAudienceRestriction(0);
        }
    }

    public void addCustomCondition(XmlObject condition) {
        ConditionsType conditions = this.getOrCreateConditions();
        ConditionAbstractType newCondition = conditions.addNewCondition();
        newCondition.set(condition);
        XmlCursor cur = newCondition.newCursor();
        cur.toNextToken();
        QName type = condition.schemaType().getName();
        if (type == null) {
            type = condition.schemaType().getDocumentElementName();
        }
        String prefix = cur.prefixForNamespace(type.getNamespaceURI());
        cur.insertNamespace(prefix, type.getNamespaceURI());
        cur.insertAttributeWithValue("type", "http://www.w3.org/2001/XMLSchema-instance", prefix + ":" + type.getLocalPart());
        cur.dispose();
    }

    public void sign(PrivateKey pk) throws DSigException {
        this.sign(pk, null);
    }

    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        DigSignatureUtil sign = new DigSignatureUtil();
        AssertionDocument unsignedDoc = this.getXMLBeanDoc();
        Document docToSign = SAMLUtils.getDOM(unsignedDoc);
        NodeList nodes = docToSign.getFirstChild().getChildNodes();
        Node sibling = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getLocalName() == null || !n.getLocalName().equals("Subject")) continue;
            sibling = n;
            break;
        }
        sign.genEnvelopedSignature(pk, null, cert, docToSign, sibling, SamlTrustChecker.ASSERTION_ID_QNAME);
        try {
            this.assertionDoc = AssertionDocument.Factory.parse(docToSign);
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }

    public void addAttribute(SAMLAttribute at) {
        this.addAttribute(at.getXBean());
    }

    public void addAttribute(AttributeType at) {
        if (this.assertionDoc.getAssertion().getAttributeStatementArray() == null || this.assertionDoc.getAssertion().getAttributeStatementArray().length == 0) {
            this.assertionDoc.getAssertion().addNewAttributeStatement();
        }
        AttributeStatementType attrStatement = this.assertionDoc.getAssertion().getAttributeStatementArray(0);
        AttributeType added = attrStatement.addNewAttribute();
        added.set(at);
    }

    public void addAuthStatement(Calendar authTime, AuthnContextType ctx, String sessionIdx, Calendar sessionEnd, SubjectLocalityType subjectLocation) {
        if (this.assertionDoc.getAssertion().getAuthnStatementArray() == null || this.assertionDoc.getAssertion().getAuthnStatementArray().length == 0) {
            this.assertionDoc.getAssertion().addNewAuthnStatement();
        }
        AuthnStatementType authStatement = this.assertionDoc.getAssertion().getAuthnStatementArray(0);
        authStatement.setAuthnInstant(authTime);
        authStatement.setAuthnContext(ctx);
        if (sessionIdx != null) {
            authStatement.setSessionIndex(sessionIdx);
        }
        if (sessionEnd != null) {
            authStatement.setSessionNotOnOrAfter(sessionEnd);
        }
        if (subjectLocation != null) {
            authStatement.setSubjectLocality(subjectLocation);
        }
    }

    public void addAuthStatement(Calendar authTime, AuthnContextType ctx) {
        this.addAuthStatement(authTime, ctx, null, null, null);
    }
}

