/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLURMEmailParser
implements EmailParser {
    private static final Logger log = LoggerFactory.getLogger(SLURMEmailParser.class);
    private static final String REGEX = "[A-Z]*\\s[a-zA-Z]*_[a-z]*=(?<jobId>\\d*)[ ]*[a-zA-Z]*=(?<jobName>[a-zA-Z0-9-]*)[ ]*(?<status>[]a-zA-Z ]*),.*";
    public static final String BEGAN = "Began";
    public static final String STAGE_OUT = "Staged Out";
    public static final String ENDED = "Ended";
    public static final String FAILED = "Failed";
    private static final Pattern cancelledStatePattern = Pattern.compile("CANCELLED");
    private static final Pattern pattern = Pattern.compile("[A-Z]*\\s[a-zA-Z]*_[a-z]*=(?<jobId>\\d*)[ ]*[a-zA-Z]*=(?<jobName>[a-zA-Z0-9-]*)[ ]*(?<status>[]a-zA-Z ]*),.*");

    public JobStatusResult parseEmail(Message message) throws MessagingException, AiravataException {
        JobStatusResult jobStatusResult = new JobStatusResult();
        this.parseSubject(message.getSubject(), jobStatusResult);
        return jobStatusResult;
    }

    private void parseSubject(String subject, JobStatusResult jobStatusResult) throws MessagingException {
        Matcher matcher = pattern.matcher(subject);
        if (matcher.find()) {
            jobStatusResult.setJobId(matcher.group("jobId"));
            jobStatusResult.setJobName(matcher.group("jobName"));
            jobStatusResult.setState(this.getJobState(matcher.group("status"), subject));
        } else {
            log.error("[EJM]: No matched found for subject -> " + subject);
        }
    }

    private JobState getJobState(String state, String subject) {
        switch (state.trim()) {
            case "Began": 
            case "Staged Out": {
                return JobState.ACTIVE;
            }
            case "Ended": {
                Matcher matcher = cancelledStatePattern.matcher(subject);
                if (matcher.find()) {
                    return JobState.CANCELED;
                }
                return JobState.COMPLETE;
            }
            case "Failed": {
                return JobState.FAILED;
            }
        }
        log.error("[EJM]: Job State " + state + " isn't handle by SLURM parser");
        return JobState.UNKNOWN;
    }
}

