/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.impl.job.JobUtil;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlurmOutputParser
implements OutputParser {
    private static final Logger log = LoggerFactory.getLogger(SlurmOutputParser.class);
    public static final int JOB_NAME_OUTPUT_LENGTH = 8;
    public static final String STATUS = "status";
    public static final String JOBID = "jobId";

    public String parseJobSubmission(String rawOutput) throws GFacException {
        log.info(rawOutput);
        Pattern pattern = Pattern.compile("Submitted batch job (?<jobId>[^\\s]*)");
        Matcher matcher = pattern.matcher(rawOutput);
        if (matcher.find()) {
            return matcher.group(JOBID);
        }
        return "";
    }

    public boolean isJobSubmissionFailed(String rawOutput) {
        Pattern pattern = Pattern.compile("FAILED");
        Matcher matcher = pattern.matcher(rawOutput);
        return matcher.find();
    }

    public JobStatus parseJobStatus(String jobID, String rawOutput) throws GFacException {
        log.info(rawOutput);
        Pattern pattern = Pattern.compile(jobID + "(?=\\s+\\S+\\s+\\S+\\s+\\S+\\s+(?<" + STATUS + ">\\w+))");
        Matcher matcher = pattern.matcher(rawOutput);
        if (matcher.find()) {
            return new JobStatus(JobUtil.getJobState(matcher.group(STATUS)));
        }
        return null;
    }

    public void parseJobStatuses(String userName, Map<String, JobStatus> statusMap, String rawOutput) throws GFacException {
        log.debug(rawOutput);
        String[] info = rawOutput.split("\n");
        String lastString = info[info.length - 1];
        if (lastString.contains("JOBID") || lastString.contains("PARTITION")) {
            log.info("There are no jobs with this username ... ");
            return;
        }
        for (String jobID : statusMap.keySet()) {
            String jobId = jobID.split(",")[0];
            String jobName = jobID.split(",")[1];
            boolean found = false;
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].contains(jobName.substring(0, 8))) continue;
                log.info(info[i]);
                String correctLine = info[i];
                String[] columns = correctLine.split(" ");
                ArrayList<String> columnList = new ArrayList<String>();
                for (String s : columns) {
                    if ("".equals(s)) continue;
                    columnList.add(s);
                }
                try {
                    statusMap.put(jobID, new JobStatus(JobState.valueOf((String)((String)columnList.get(4)))));
                }
                catch (IndexOutOfBoundsException e) {
                    statusMap.put(jobID, new JobStatus(JobState.valueOf((String)"U")));
                }
                found = true;
                break;
            }
            if (found) continue;
            log.error("Couldn't find the status of the Job with JobName: " + jobName + "Job Id: " + jobId);
        }
    }

    public String parseJobId(String jobName, String rawOutput) throws GFacException {
        String regJobId = JOBID;
        if (jobName == null) {
            return null;
        }
        if (jobName.length() > 8) {
            jobName = jobName.substring(0, 8);
        }
        Pattern pattern = Pattern.compile("(?=(?<" + regJobId + ">\\d+)\\s+\\w+\\s+" + jobName + ")");
        if (rawOutput != null) {
            Matcher matcher = pattern.matcher(rawOutput);
            if (matcher.find()) {
                return matcher.group(regJobId);
            }
            log.error("No match is found for JobName");
            return null;
        }
        log.error("Error: RawOutput shouldn't be null");
        return null;
    }
}

