/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.security.core.util.HostUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.ssl.MyTrustManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.codec.binary.Base64;

public class MyProxyLogon {
    MyLoggingFacade mlf = null;
    public static final String version = "1.6";
    private static final int b64linelen = 64;
    private static final String X509_USER_PROXY_FILE = "x509up_u";
    private static final String VERSION = "VERSION=MYPROXYv2";
    private static final String GETCOMMAND = "COMMAND=0";
    private static final String TRUSTROOTS = "TRUSTED_CERTS=";
    private static final String USERNAME = "USERNAME=";
    private static final String PASSPHRASE = "PASSPHRASE=";
    private static final String LIFETIME = "LIFETIME=";
    private static final String CREDNAME = "CRED_NAME=";
    private static final String RESPONSE = "RESPONSE=";
    private static final String ERROR = "ERROR=";
    private static final String DN = "CN=ignore";
    private static final String TRUSTED_CERT_PATH = "/.globus/certificates";
    public final int DEFAULT_KEY_SIZE = 2048;
    protected int keySize = 2048;
    protected final int MIN_PASS_PHRASE_LEN = 6;
    protected static final String keyAlg = "RSA";
    protected static final String pkcs10SigAlgName = "SHA1withRSA";
    protected static final String pkcs10Provider = "BC";
    protected State state = State.READY;
    protected String host = "localhost";
    protected String username;
    protected String credname;
    protected String passphrase;
    protected int port = 7512;
    protected int lifetime = 43200;
    protected boolean requestTrustRoots = false;
    protected SSLSocket socket;
    protected BufferedInputStream socketIn;
    protected BufferedOutputStream socketOut;
    protected KeyPair keypair;
    protected Collection<X509Certificate> certificateChain;
    protected String[] trustrootFilenames;
    protected String[] trustrootData;
    KeyManagerFactory keyManagerFactory;

    public MyLoggingFacade getMlf() {
        return this.mlf;
    }

    public MyProxyLogon(MyLoggingFacade myLoggingFacade) {
        this.mlf = myLoggingFacade;
    }

    public MyProxyLogon() {
        String portString;
        this.host = System.getenv("MYPROXY_SERVER");
        if (this.host == null) {
            this.host = "localhost";
        }
        if ((portString = System.getenv("MYPROXY_SERVER_PORT")) != null) {
            this.port = Integer.parseInt(portString);
        }
        this.username = System.getProperty("user.name");
    }

    public String getHost() {
        return this.host;
    }

    protected String hostLookup() throws UnknownHostException {
        return HostUtil.canonicalName((String)this.getHost());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCredentialName() {
        return this.credname;
    }

    public void setCredentialName(String credname) {
        this.credname = credname;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int seconds) {
        this.lifetime = seconds;
    }

    public Collection<X509Certificate> getCertificates() {
        return this.certificateChain;
    }

    public PrivateKey getPrivateKey() {
        return this.keypair.getPrivate();
    }

    public void requestTrustRoots(boolean flag) {
        this.requestTrustRoots = flag;
    }

    public String[] getTrustRootFilenames() {
        return this.trustrootFilenames;
    }

    public String[] getTrustRootData() {
        return this.trustrootData;
    }

    public void connect() throws IOException, GeneralSecurityException {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            MyTrustManager mtm = new MyTrustManager(this.getMlf(), MyProxyLogon.getExistingTrustRootPath());
            mtm.setHost(this.hostLookup());
            TrustManager[] trustAllCerts = new TrustManager[]{mtm};
            sc.init(this.getKeyManagers(), trustAllCerts, new SecureRandom());
            SSLSocketFactory sf = sc.getSocketFactory();
            this.socket = (SSLSocket)sf.createSocket(this.hostLookup(), this.port);
            this.socket.setEnabledProtocols(new String[]{"SSLv3"});
            this.socket.startHandshake();
            this.socketIn = new BufferedInputStream(this.socket.getInputStream());
            this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
            this.state = State.CONNECTED;
        }
        catch (Throwable t) {
            this.handleException(t, this.getClass().getSimpleName() + " could not connect to the server, socket " + (this.socket == null ? "" : "not") + " created.");
        }
    }

    protected void handleException(Throwable t, String msg) throws IOException, GeneralSecurityException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof GeneralSecurityException) {
            throw (GeneralSecurityException)t;
        }
        throw new GeneralSecurityException("Error: " + msg, t);
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public void setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    KeyManager[] getKeyManagers() {
        if (this.getKeyManagerFactory() == null) {
            return null;
        }
        return this.getKeyManagerFactory().getKeyManagers();
    }

    public void disconnect() throws IOException, GeneralSecurityException {
        try {
            this.socket.close();
            this.socket = null;
            this.socketIn = null;
            this.socketOut = null;
            this.state = State.READY;
        }
        catch (Throwable t) {
            this.handleException(t, this.getClass().getSimpleName() + " could not disconnect from the server, socket " + (this.socket == null ? "" : "not") + " created");
        }
    }

    public void logon() throws IOException, GeneralSecurityException {
        if (this.state != State.CONNECTED) {
            this.connect();
        }
        try {
            this.socketOut.write(48);
            this.socketOut.flush();
            this.socketOut.write(VERSION.getBytes());
            this.socketOut.write(10);
            this.socketOut.write(GETCOMMAND.getBytes());
            this.socketOut.write(10);
            this.socketOut.write(USERNAME.getBytes());
            this.socketOut.write(this.username.getBytes());
            this.socketOut.write(10);
            this.socketOut.write(PASSPHRASE.getBytes());
            this.socketOut.write(this.passphrase.getBytes());
            this.socketOut.write(10);
            this.socketOut.write(LIFETIME.getBytes());
            this.socketOut.write(Integer.toString(this.lifetime).getBytes());
            this.socketOut.write(10);
            if (this.credname != null) {
                this.socketOut.write(CREDNAME.getBytes());
                this.socketOut.write(this.credname.getBytes());
                this.socketOut.write(10);
            }
            if (this.requestTrustRoots) {
                this.socketOut.write(TRUSTROOTS.getBytes());
                this.socketOut.write("1\n".getBytes());
            }
            this.socketOut.flush();
            String line = this.readLine(this.socketIn);
            if (line == null) {
                throw new EOFException();
            }
            if (!line.equals(VERSION)) {
                throw new ProtocolException("bad MyProxy protocol VERSION string: " + line);
            }
            line = this.readLine(this.socketIn);
            if (line == null) {
                throw new EOFException();
            }
            if (!line.startsWith(RESPONSE) || line.length() != RESPONSE.length() + 1) {
                throw new ProtocolException("bad MyProxy protocol RESPONSE string: " + line);
            }
            char response = line.charAt(RESPONSE.length());
            if (response == '1') {
                StringBuffer errString = new StringBuffer("MyProxy logon failed");
                while ((line = this.readLine(this.socketIn)) != null) {
                    if (!line.startsWith(ERROR)) continue;
                    errString.append('\n');
                    errString.append(line.substring(ERROR.length()));
                }
                throw new FailedLoginException(errString.toString());
            }
            if (response == '2') {
                throw new ProtocolException("MyProxy authorization RESPONSE not implemented");
            }
            if (response != '0') {
                throw new ProtocolException("unknown MyProxy protocol RESPONSE string: " + line);
            }
            while ((line = this.readLine(this.socketIn)) != null) {
                if (!line.startsWith(TRUSTROOTS)) continue;
                String filenameList = line.substring(TRUSTROOTS.length());
                this.trustrootFilenames = filenameList.split(",");
                this.trustrootData = new String[this.trustrootFilenames.length];
                for (int i = 0; i < this.trustrootFilenames.length; ++i) {
                    String lineStart = "FILEDATA_" + this.trustrootFilenames[i] + "=";
                    line = this.readLine(this.socketIn);
                    if (line == null) {
                        throw new EOFException();
                    }
                    if (!line.startsWith(lineStart)) {
                        throw new ProtocolException("bad MyProxy protocol RESPONSE: expecting " + lineStart + " but received " + line);
                    }
                    this.trustrootData[i] = new String(Base64.decodeBase64((String)line.substring(lineStart.length())));
                }
            }
            this.state = State.LOGGEDON;
        }
        catch (Throwable t) {
            this.handleException(t, this.getClass().getSimpleName() + " logon failed.");
        }
    }

    public void getCredentials(byte[] derEncodedCertRequest) throws IOException, GeneralSecurityException {
        try {
            if (this.state != State.LOGGEDON) {
                this.logon();
            }
            this.socketOut.write(derEncodedCertRequest);
            this.socketOut.flush();
            int numCertificates = this.socketIn.read();
            if (numCertificates == -1) {
                System.err.println("connection aborted");
                throw new IOException("Error: connection aborted");
            }
            if (numCertificates == 0 || numCertificates < 0) {
                System.err.print("bad number of certificates sent by server: ");
                System.err.println(Integer.toString(numCertificates));
                throw new GeneralSecurityException("Error: bad number of certificates sent by server");
            }
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            this.certificateChain = certFactory.generateCertificates(this.socketIn);
            this.state = State.DONE;
        }
        catch (Throwable t) {
            this.handleException(t, this.getClass().getSimpleName() + " failure getting the credential.");
        }
    }

    public void getCredentials() throws IOException, GeneralSecurityException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(keyAlg);
        keyGenerator.initialize(this.getKeySize());
        this.keypair = keyGenerator.genKeyPair();
        MyPKCS10CertRequest pkcs10 = CertUtil.createCertRequest((KeyPair)this.keypair, (String)pkcs10SigAlgName, (String)DN, (String)pkcs10Provider);
        this.getCredentials(pkcs10.getEncoded());
    }

    public void writeProxyFile() throws IOException, GeneralSecurityException {
        this.saveCredentialsToFile(MyProxyLogon.getProxyLocation());
    }

    public void saveCredentials(OutputStream os) throws IOException, GeneralSecurityException {
        CertUtil.toPEM(this.certificateChain, (OutputStream)os);
        os.write(10);
        KeyUtil.toPKCS1PEM((PrivateKey)this.keypair.getPrivate(), (OutputStream)os);
    }

    public X509Certificate getCertificate() {
        if (this.certificateChain == null) {
            return null;
        }
        Iterator<X509Certificate> iter = this.certificateChain.iterator();
        return iter.next();
    }

    public void saveCredentialsToFile(String filename) throws IOException, GeneralSecurityException {
        File outFile = new File(filename);
        outFile.delete();
        outFile.createNewFile();
        this.setFilePermissions(filename, "0600");
        FileOutputStream fos = new FileOutputStream(outFile);
        this.saveCredentials(fos);
        fos.flush();
        fos.close();
    }

    public boolean writeTrustRoots() throws IOException {
        return this.writeTrustRoots(MyProxyLogon.getTrustRootPath());
    }

    public boolean writeTrustRoots(String directory) throws IOException {
        if (this.trustrootFilenames == null || this.trustrootData == null) {
            return false;
        }
        File rootDir = new File(directory);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        for (int i = 0; i < this.trustrootFilenames.length; ++i) {
            FileOutputStream out = new FileOutputStream(directory + File.separator + this.trustrootFilenames[i]);
            out.write(this.trustrootData[i].getBytes());
            out.close();
        }
        return true;
    }

    public X509Certificate[] getTrustedCAs() throws CertificateException {
        if (this.trustrootData == null) {
            return null;
        }
        return CertUtil.getX509CertsFromStringList((String[])this.trustrootData, (String[])this.trustrootFilenames);
    }

    public X509CRL[] getCRLs() throws CertificateException {
        if (this.trustrootData == null) {
            return null;
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509CRL> c = new ArrayList<X509CRL>(this.trustrootData.length);
        for (int i = 0; i < this.trustrootData.length; ++i) {
            String crlData = this.trustrootData[i];
            int index = crlData.indexOf("-----BEGIN X509 CRL-----");
            if (index < 0) continue;
            crlData = crlData.substring(index);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(crlData.getBytes());
            try {
                X509CRL crl = (X509CRL)certFactory.generateCRL(inputStream);
                c.add(crl);
                continue;
            }
            catch (Exception e) {
                this.getMlf().warn(this.trustrootFilenames[i] + " can not be parsed as an X509CRL.");
            }
        }
        if (c.isEmpty()) {
            return null;
        }
        return c.toArray(new X509CRL[0]);
    }

    public static String getTrustRootPath() {
        String path = System.getenv("X509_CERT_DIR");
        if (path == null) {
            path = System.getProperty("X509_CERT_DIR");
        }
        if (path == null) {
            path = System.getProperty("user.home") + TRUSTED_CERT_PATH;
        }
        return path;
    }

    public static String getExistingTrustRootPath() {
        String path;
        String GL = System.getenv("GLOBUS_LOCATION");
        if (GL == null) {
            GL = System.getProperty("GLOBUS_LOCATION");
        }
        if ((path = System.getenv("X509_CERT_DIR")) == null) {
            path = System.getProperty("X509_CERT_DIR");
        }
        if (path == null) {
            path = MyProxyLogon.getDir(System.getProperty("user.home") + TRUSTED_CERT_PATH);
        }
        if (path == null) {
            path = MyProxyLogon.getDir("/etc/grid-security/certificates");
        }
        if (path == null) {
            path = MyProxyLogon.getDir(GL + File.separator + "share" + File.separator + "certificates");
        }
        return path;
    }

    public static String getProxyLocation() throws IOException {
        String suffix = null;
        String loc = System.getenv("X509_USER_PROXY");
        if (loc == null) {
            loc = System.getProperty("X509_USER_PROXY");
        }
        if (loc != null) {
            return loc;
        }
        try {
            Process proc = Runtime.getRuntime().exec("id -u");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            suffix = bufferedReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (suffix == null) {
            suffix = System.getProperty("user.name");
            suffix = suffix != null ? suffix.toLowerCase() : "nousername";
        }
        if (File.separator.equals("/")) {
            return "/tmp/x509up_u" + suffix;
        }
        return System.getProperty("java.io.tmpdir") + File.separator + X509_USER_PROXY_FILE + suffix;
    }

    public static void main(String[] args) {
        try {
            X509CRL[] CRLs;
            MyLoggingFacade myLoggingFacade = new MyLoggingFacade(MyProxyLogon.class.getName());
            MyProxyLogon m = new MyProxyLogon(myLoggingFacade);
            String passphrase = null;
            System.out.println("Warning: terminal will echo passphrase as you type.");
            System.out.print("MyProxy Passphrase: ");
            passphrase = m.readLine(System.in);
            if (passphrase == null) {
                System.err.println("Error reading passphrase.");
                System.exit(1);
            }
            m.setPassphrase(passphrase);
            m.requestTrustRoots(true);
            m.getCredentials();
            m.writeProxyFile();
            System.out.println("Credential written successfully.");
            X509Certificate[] CAcerts = m.getTrustedCAs();
            if (CAcerts != null) {
                System.out.println(Integer.toString(CAcerts.length) + " CA certificates received.");
            }
            if ((CRLs = m.getCRLs()) != null) {
                System.out.println(Integer.toString(CRLs.length) + " CRLs received.");
            }
            if (m.writeTrustRoots()) {
                System.out.println("Wrote trust roots to " + MyProxyLogon.getTrustRootPath() + ".");
            } else {
                System.out.println("Received no trust roots from MyProxy server.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void setFilePermissions(String file, String mode) {
        String command = "chmod " + mode + " " + file;
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            this.getMlf().warn("Failed to run: " + command);
        }
    }

    private String readLine(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = is.read();
        while (c > 0 && c != 10) {
            sb.append((char)c);
            c = is.read();
        }
        if (sb.length() > 0) {
            return new String(sb);
        }
        return null;
    }

    private static String getDir(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (f.isDirectory() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    protected static enum State {
        READY,
        CONNECTED,
        LOGGEDON,
        DONE;

    }
}

