/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.common.utils.IOUtil;

public class JSONUtil {
    public static void saveJSON(JsonElement jsonElement, File file) throws IOException {
        IOUtil.writeToFile(JSONUtil.jsonElementToString(jsonElement), file);
    }

    public static JsonObject stringToJSONObject(String workflowString) {
        JsonParser parser = new JsonParser();
        return (JsonObject)parser.parse(workflowString);
    }

    public static JsonObject loadJSON(File file) throws IOException {
        return JSONUtil.loadJSON(new FileReader(file));
    }

    public static JsonObject loadJSON(Reader reader) throws IOException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(reader);
        if (jsonElement instanceof JsonObject) {
            return (JsonObject)jsonElement;
        }
        throw new RuntimeException("Error while loading Json from file");
    }

    public static String jsonElementToString(JsonElement jsonElement) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(jsonElement);
    }

    public static boolean isEqual(JsonObject originalJsonObject, JsonObject newJsonObject) {
        if (originalJsonObject == null && newJsonObject == null) {
            return true;
        }
        if (originalJsonObject == null || newJsonObject == null) {
            return false;
        }
        Set entrySetOfOriginalJson = originalJsonObject.entrySet();
        Set entrySetOfNewJson = newJsonObject.entrySet();
        if (entrySetOfOriginalJson.size() != entrySetOfNewJson.size()) {
            return false;
        }
        for (Map.Entry keyString : entrySetOfOriginalJson) {
            JsonElement valueOrig = (JsonElement)keyString.getValue();
            JsonElement valueNew = newJsonObject.get((String)keyString.getKey());
            if (valueOrig instanceof JsonObject && valueNew instanceof JsonObject && !JSONUtil.isEqual((JsonObject)valueOrig, (JsonObject)valueNew)) {
                return false;
            }
            if (valueOrig instanceof JsonArray && valueNew instanceof JsonArray && !JSONUtil.isEqual((JsonArray)valueOrig, (JsonArray)valueNew)) {
                return false;
            }
            if (!(valueOrig instanceof JsonPrimitive) || !(valueNew instanceof JsonPrimitive) || JSONUtil.isEqual((JsonPrimitive)valueOrig, (JsonPrimitive)valueNew)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(JsonArray arrayOriginal, JsonArray arrayNew) {
        if (arrayOriginal == null && arrayNew == null) {
            return true;
        }
        if (arrayOriginal == null || arrayNew == null) {
            return false;
        }
        if (arrayOriginal.size() != arrayNew.size()) {
            return false;
        }
        if (arrayOriginal.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayOriginal.size(); ++i) {
            JsonElement valueOrig = arrayOriginal.get(i);
            JsonElement valueNew = arrayNew.get(i);
            if (!(valueOrig instanceof JsonObject && valueNew instanceof JsonObject ? !JSONUtil.isEqual((JsonObject)valueOrig, (JsonObject)valueNew) : valueOrig instanceof JsonPrimitive && valueNew instanceof JsonPrimitive && !JSONUtil.isEqual((JsonPrimitive)valueOrig, (JsonPrimitive)valueNew))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(JsonPrimitive primitiveOrig, JsonPrimitive primitiveNew) {
        if (primitiveOrig == null && primitiveNew == null) {
            return true;
        }
        if (primitiveOrig == null || primitiveNew == null) {
            return false;
        }
        if (primitiveOrig.isString() && primitiveNew.isString()) {
            if (!primitiveOrig.getAsString().equals(primitiveNew.getAsString())) {
                return false;
            }
        } else if (primitiveOrig.isBoolean() && primitiveNew.isBoolean()) {
            if (Boolean.valueOf(primitiveOrig.getAsBoolean()).compareTo(primitiveNew.getAsBoolean()) != 0) {
                return false;
            }
        } else if (primitiveOrig.isNumber() && primitiveNew.isNumber()) {
            if (new Double(primitiveOrig.getAsDouble()).compareTo(primitiveNew.getAsDouble()) != 0) {
                return false;
            }
        } else {
            return primitiveOrig.isJsonNull() && primitiveNew.isJsonNull();
        }
        return true;
    }
}

