/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class JdbcStoreException
extends IOException {
    private static final long serialVersionUID = 6238846660780283933L;
    private Throwable cause;

    public JdbcStoreException(String msg) {
        super(msg);
    }

    public JdbcStoreException(String msg, Throwable ex) {
        super(msg);
        this.cause = ex;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is " + this.getCause().getClass().getName() + ": " + this.getCause().getMessage();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.getCause().printStackTrace(pw);
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        Throwable ex = this;
        while (ex != null) {
            if (exClass.isInstance(ex)) {
                return true;
            }
            if (ex instanceof JdbcStoreException) {
                ex = ((Throwable)ex).getCause();
                continue;
            }
            ex = null;
        }
        return false;
    }
}

