/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SecurityUtils;

public enum KeyType {
    RSA("ssh-rsa"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            BigInteger n;
            BigInteger e;
            try {
                e = buf.readMPInt();
                n = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
            return keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            RSAPublicKey rsaKey = (RSAPublicKey)pk;
            ((Buffer)((Buffer)buf.putString(this.sType)).putMPInt(rsaKey.getPublicExponent())).putMPInt(rsaKey.getModulus());
        }

        @Override
        protected boolean isMyType(Key key) {
            return key instanceof RSAPublicKey || key instanceof RSAPrivateKey;
        }
    }
    ,
    DSA("ssh-dss"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            BigInteger y;
            BigInteger g;
            BigInteger q;
            BigInteger p;
            try {
                p = buf.readMPInt();
                q = buf.readMPInt();
                g = buf.readMPInt();
                y = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
            return keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            DSAPublicKey dsaKey = (DSAPublicKey)pk;
            ((Buffer)((Buffer)((Buffer)((Buffer)buf.putString(this.sType)).putMPInt(dsaKey.getParams().getP())).putMPInt(dsaKey.getParams().getQ())).putMPInt(dsaKey.getParams().getG())).putMPInt(dsaKey.getY());
        }

        @Override
        protected boolean isMyType(Key key) {
            return key instanceof DSAPublicKey || key instanceof DSAPrivateKey;
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            throw new UnsupportedOperationException("Don't know how to decode key:" + type);
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            throw new UnsupportedOperationException("Don't know how to encode key: " + pk);
        }

        @Override
        protected boolean isMyType(Key key) {
            return false;
        }
    };

    protected final String sType;

    private KeyType(String type) {
        this.sType = type;
    }

    public abstract PublicKey readPubKeyFromBuffer(String var1, Buffer<?> var2) throws GeneralSecurityException;

    public abstract void putPubKeyIntoBuffer(PublicKey var1, Buffer<?> var2);

    protected abstract boolean isMyType(Key var1);

    public static KeyType fromKey(Key key) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.isMyType(key)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public static KeyType fromString(String sType) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.sType.equals(sType)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.sType;
    }
}

