/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.util.Comparator;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.rop.ResultObjectProvider;

public class MergedResultObjectProvider
implements ResultObjectProvider {
    private static final byte UNOPENED = 0;
    private static final byte OPENED = 1;
    private static final byte VALUE = 2;
    private static final byte DONE = 3;
    private final ResultObjectProvider[] _rops;
    private final Comparator _comp;
    private final byte[] _status;
    private Object[] _values;
    private Object[] _orderValues;
    private Object _cur = null;
    private int _size = -1;

    public MergedResultObjectProvider(ResultObjectProvider[] rops) {
        this(rops, null);
    }

    public MergedResultObjectProvider(ResultObjectProvider[] rops, Comparator comp) {
        this._rops = rops;
        this._comp = comp;
        this._status = new byte[rops.length];
        this._values = comp == null ? null : new Object[rops.length];
        this._orderValues = comp == null ? null : new Object[rops.length];
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    @Override
    public void open() throws Exception {
        int len = this._comp != null ? this._rops.length : 1;
        for (int i = 0; i < len; ++i) {
            this._rops[i].open();
            this._status[i] = 1;
        }
    }

    @Override
    public boolean absolute(int pos) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws Exception {
        if (this._size != -1) {
            return this._size;
        }
        for (int i = 0; i < this._status.length; ++i) {
            if (this._status[i] != 0) continue;
            this._rops[i].open();
            this._status[i] = 1;
        }
        int total = 0;
        for (int i = 0; i < this._rops.length; ++i) {
            int size = this._rops[i].size();
            if (size == Integer.MAX_VALUE) {
                total = size;
                break;
            }
            total += size;
        }
        this._size = total;
        return this._size;
    }

    @Override
    public void reset() throws Exception {
        for (int i = 0; i < this._rops.length; ++i) {
            if (this._status[i] == 0) continue;
            this._rops[i].reset();
        }
        this.clear();
    }

    @Override
    public void close() throws Exception {
        Exception err = null;
        for (int i = 0; i < this._rops.length; ++i) {
            try {
                if (this._status[i] == 0) continue;
                this._rops[i].close();
                continue;
            }
            catch (Exception e) {
                if (err != null) continue;
                err = e;
            }
        }
        this.clear();
        if (err != null) {
            throw err;
        }
    }

    private void clear() {
        this._cur = null;
        for (int i = 0; i < this._rops.length; ++i) {
            this._status[i] = 1;
            if (this._values != null) {
                this._values[i] = null;
            }
            if (this._orderValues == null) continue;
            this._orderValues[i] = null;
        }
    }

    @Override
    public void handleCheckedException(Exception e) {
        if (this._rops.length == 0) {
            throw new NestableRuntimeException(e);
        }
        this._rops[0].handleCheckedException(e);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasValue = false;
        block5: for (int i = 0; i < this._status.length; ++i) {
            switch (this._status[i]) {
                case 0: {
                    this._rops[i].open();
                    this._status[i] = 1;
                }
                case 1: {
                    if (this._rops[i].next()) {
                        if (this._comp == null) {
                            this._cur = this._rops[i].getResultObject();
                            return true;
                        }
                        hasValue = true;
                        this._status[i] = 2;
                        this._values[i] = this._rops[i].getResultObject();
                        this._orderValues[i] = this.getOrderingValue(this._values[i], i, this._rops[i]);
                        continue block5;
                    }
                    this._status[i] = 3;
                    continue block5;
                }
                case 2: {
                    hasValue = true;
                }
            }
        }
        if (this._comp == null || !hasValue) {
            return false;
        }
        int least = -1;
        Object orderVal = null;
        for (int i = 0; i < this._orderValues.length; ++i) {
            if (this._status[i] != 2 || least != -1 && this._comp.compare(this._orderValues[i], orderVal) >= 0) continue;
            least = i;
            orderVal = this._orderValues[i];
        }
        this._cur = this._values[least];
        this._values[least] = null;
        this._orderValues[least] = null;
        this._status[least] = 1;
        return true;
    }

    @Override
    public Object getResultObject() throws Exception {
        return this._cur;
    }

    protected Object getOrderingValue(Object val, int idx, ResultObjectProvider rop) {
        return val;
    }
}

