/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.HashMap;
import java.util.List;
import org.apache.airavata.sharing.registry.db.entities.SharingEntity;
import org.apache.airavata.sharing.registry.db.entities.SharingPK;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.db.repositories.PermissionTypeRepository;
import org.apache.airavata.sharing.registry.models.Sharing;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.SharingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingRepository
extends AbstractRepository<Sharing, SharingEntity, SharingPK> {
    private static final Logger logger = LoggerFactory.getLogger(SharingRepository.class);

    public SharingRepository() {
        super(Sharing.class, SharingEntity.class);
    }

    public List<Sharing> getIndirectSharedChildren(String domainId, String parentId, String permissionTypeId) throws SharingRegistryException {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("domainId", domainId);
        filters.put("inheritedParentId", parentId);
        filters.put("sharingType", SharingType.INDIRECT_CASCADING.toString());
        filters.put("permissionTypeId", permissionTypeId);
        return this.select(filters, 0, -1);
    }

    public List<Sharing> getCascadingPermissionsForEntity(String domainId, String entityId) throws SharingRegistryException {
        String query = "SELECT DISTINCT p from " + SharingEntity.class.getSimpleName() + " as p";
        query = query + " WHERE ";
        query = query + "p.domainId = :domainId AND ";
        query = query + "p.entityId = :entityId AND ";
        query = query + "p.sharingType IN('" + SharingType.DIRECT_CASCADING.toString() + "', '" + SharingType.INDIRECT_CASCADING + "') ";
        query = query + " ORDER BY p.createdTime DESC";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("entityId", entityId);
        return this.select(query, queryParameters, 0, -1);
    }

    public boolean hasAccess(String domainId, String entityId, List<String> groupIds, List<String> permissionTypeIds) throws SharingRegistryException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String query = "SELECT p from " + SharingEntity.class.getSimpleName() + " as p";
        query = query + " WHERE ";
        query = query + "p.domainId = :domainId AND ";
        query = query + "p.entityId = :entityId AND ";
        queryParameters.put("domainId", domainId);
        queryParameters.put("entityId", entityId);
        query = query + "p.permissionTypeId IN :permissionTypeId AND ";
        queryParameters.put("permissionTypeId", permissionTypeIds);
        query = query + "p.groupId IN :groupId ";
        queryParameters.put("groupId", groupIds);
        query = query + " ORDER BY p.createdTime DESC";
        return this.select(query, queryParameters, 0, -1).size() > 0;
    }

    public int getSharedCount(String domainId, String entityId) throws SharingRegistryException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String query = "SELECT p from " + SharingEntity.class.getSimpleName() + " as p";
        query = query + " WHERE ";
        query = query + "p.domainId = :domainId AND ";
        queryParameters.put("domainId", domainId);
        query = query + "p.entityId = :entityId AND ";
        queryParameters.put("entityId", entityId);
        String permissionTypeIdString = new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId);
        query = query + "p.permissionTypeId <> :permissionTypeId AND ";
        queryParameters.put("permissionTypeId", permissionTypeIdString);
        query = query + "p.sharingType <> :sharingType";
        queryParameters.put("sharingType", SharingType.INDIRECT_CASCADING.toString());
        return this.select(query, queryParameters, 0, -1).size();
    }
}

